/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.DataOutput;
import java.io.IOException;
import net.automatalib.serialization.saf.BlockPropertyEncoder;

final class AcceptanceEncoder
implements BlockPropertyEncoder<Boolean> {
    private int currAcc;
    private int mask;

    AcceptanceEncoder() {
    }

    @Override
    public void start(DataOutput out) {
        this.currAcc = 0;
        this.mask = 1;
    }

    @Override
    public void encodeProperty(DataOutput out, Boolean property) throws IOException {
        if (this.mask == 0) {
            this.finish(out);
            this.start(out);
        }
        if (property.booleanValue()) {
            this.currAcc |= this.mask;
        }
        this.mask <<= 1;
    }

    @Override
    public void finish(DataOutput out) throws IOException {
        out.writeInt(this.currAcc);
    }
}

