/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.automatalib.incremental.mealy.tree.AbstractIncrementalMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.AnnotatedEdge;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.incremental.mealy.tree.dynamic.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DynamicIncrementalMealyTreeBuilder<I, O>
extends AbstractIncrementalMealyTreeBuilder<Node<I, O>, I, O> {
    public DynamicIncrementalMealyTreeBuilder() {
        this(new Node());
    }

    DynamicIncrementalMealyTreeBuilder(Node<I, O> root) {
        super(root);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
    }

    @Override
    protected @Nullable Edge<Node<I, O>, O> getEdge(Node<I, O> node, I symbol) {
        return node.getEdge(symbol);
    }

    @Override
    protected Node<I, O> createNode() {
        return new Node();
    }

    @Override
    protected Node<I, O> insertNode(Node<I, O> parent, I symbols, O output) {
        Object succ = this.createNode();
        Edge<Object, O> edge = new Edge<Object, O>(output, succ);
        parent.setEdge(symbols, edge);
        return succ;
    }

    @Override
    protected Collection<AnnotatedEdge<Node<I, O>, I, O>> getOutgoingEdges(Node<I, O> node) {
        Map<I, Edge<Node<I, O>, O>> outEdges = node.getOutEdges();
        ArrayList<AnnotatedEdge<Node<I, O>, I, O>> result = new ArrayList<AnnotatedEdge<Node<I, O>, I, O>>(outEdges.size());
        for (Map.Entry<I, Edge<Node<I, O>, O>> e : outEdges.entrySet()) {
            if (e.getValue() == null) continue;
            result.add(new AnnotatedEdge<Node<I, O>, I, O>(e.getValue(), e.getKey()));
        }
        return result;
    }
}

