/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.functions;

import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.automatalib.commons.util.functions.BiIntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FunctionsUtil {
    private FunctionsUtil() {
        throw new AssertionError();
    }

    public static <T, R> Function<T, ? extends @Nullable R> safeDefault(@Nullable Function<T, R> func) {
        if (func == null) {
            return x -> null;
        }
        return func;
    }

    public static <R> IntFunction<? extends @Nullable R> safeDefault(@Nullable IntFunction<R> func) {
        if (func == null) {
            return i -> null;
        }
        return func;
    }

    public static <R> BiIntFunction<? extends @Nullable R> safeDefault(@Nullable BiIntFunction<R> func) {
        if (func == null) {
            return (i1, i2) -> null;
        }
        return func;
    }

    public static <T> Predicate<T> safeToTrue(@Nullable Predicate<T> func) {
        if (func == null) {
            return x -> true;
        }
        return func;
    }

    public static <T> Predicate<T> safeToFalse(@Nullable Predicate<T> func) {
        if (func == null) {
            return x -> false;
        }
        return func;
    }
}

