/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.automatalib.commons.smartcollections.AbstractSmartCollection;
import net.automatalib.commons.smartcollections.CapacityManagement;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.InvalidReferenceException;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

public class UnorderedCollection<E>
extends AbstractSmartCollection<E>
implements CapacityManagement {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final ResizingArrayStorage<Reference<E>> storage;
    private int size;

    public UnorderedCollection() {
        this(10);
    }

    public UnorderedCollection(int initialCapacity) {
        int capacity = initialCapacity <= 0 ? 10 : initialCapacity;
        this.storage = new ResizingArrayStorage<Reference>(Reference.class, capacity);
    }

    public UnorderedCollection(Collection<? extends E> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    @Override
    public boolean ensureCapacity(@UnknownInitialization(value=UnorderedCollection.class) UnorderedCollection<E> this, int minCapacity) {
        return this.storage.ensureCapacity(minCapacity);
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalSpace) {
        return this.ensureCapacity(this.size + additionalSpace);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.storage.hintNextCapacity(nextCapacityHint);
    }

    @Override
    public E get(ElementReference ref) {
        Reference<E> r = UnorderedCollection.asIndexedRef(ref);
        return r.element;
    }

    private static <E> Reference<E> asIndexedRef(ElementReference ref) {
        if (ref.getClass() != Reference.class) {
            throw new InvalidReferenceException("Reference is of wrong class '" + ref.getClass().getName() + "', should be " + Reference.class.getName() + ".");
        }
        return (Reference)ref;
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        Reference<E> ref;
        this.ensureCapacity(this.size + 1);
        int insertPos = this.size++;
        ((Reference[])this.storage.array)[insertPos] = ref = new Reference<E>(elem, insertPos);
        return ref;
    }

    @Override
    public void remove(ElementReference ref) {
        this.remove(this.extractValidIndex(ref));
    }

    private void remove(int index) {
        Reference lastElem;
        int lastIndex = --this.size;
        Reference removed = ((Reference[])this.storage.array)[index];
        ((Reference[])this.storage.array)[index] = lastElem = ((Reference[])this.storage.array)[lastIndex];
        lastElem.index = index;
        removed.index = -1;
        ((Reference[])this.storage.array)[lastIndex] = null;
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new ReferenceIterator();
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        int idx = this.extractValidIndex(ref);
        ((Reference[])this.storage.array)[idx].element = newElement;
    }

    private int extractValidIndex(ElementReference ref) {
        Reference<E> iRef = UnorderedCollection.asIndexedRef(ref);
        int idx = iRef.index;
        if (idx < 0 || idx >= this.size) {
            throw new InvalidReferenceException("Index " + idx + " is not valid for collection with size " + this.size + ".");
        }
        return idx;
    }

    @Override
    public E choose() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return ((Reference[])this.storage.array)[0].element;
    }

    @Override
    public ElementReference chooseRef() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return ((Reference[])this.storage.array)[0];
    }

    @Override
    public Iterable<ElementReference> references() {
        return this::referenceIterator;
    }

    @Override
    public <T extends E> void addAll(T[] array) {
        this.ensureCapacity(this.size + array.length);
        for (T t : array) {
            ((Reference[])this.storage.array)[this.size] = new Reference<T>(t, this.size);
            ++this.size;
        }
    }

    @Override
    public boolean addAll(@UnknownInitialization(value=UnorderedCollection.class) UnorderedCollection<E> this, Collection<? extends E> coll) {
        if (coll.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + coll.size());
        for (E elem : coll) {
            ((Reference[])this.storage.array)[this.size] = new Reference<E>(elem, this.size);
            ++this.size;
        }
        return true;
    }

    @Override
    public void quickClear() {
        this.size = 0;
    }

    @Override
    public void deepClear() {
        this.storage.setAll(null);
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            ((Reference[])this.storage.array)[i].index = -1;
            ((Reference[])this.storage.array)[i] = null;
        }
        this.size = 0;
    }

    public void swap(UnorderedCollection<E> other) {
        int sizeTmp = this.size;
        this.size = other.size;
        other.size = sizeTmp;
        this.storage.swap(other.storage);
    }

    private class ElementIterator
    implements Iterator<E> {
        private int index;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < UnorderedCollection.this.size;
        }

        @Override
        public E next() {
            if (this.index >= UnorderedCollection.this.size) {
                throw new NoSuchElementException();
            }
            return ((Reference[])((UnorderedCollection)UnorderedCollection.this).storage.array)[this.index++].element;
        }

        @Override
        public void remove() {
            if (this.index <= 0) {
                throw new IllegalStateException();
            }
            UnorderedCollection.this.remove(--this.index);
        }
    }

    private class ReferenceIterator
    implements Iterator<ElementReference> {
        private int index;

        private ReferenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < UnorderedCollection.this.size;
        }

        @Override
        public ElementReference next() {
            if (this.index >= UnorderedCollection.this.size) {
                throw new NoSuchElementException();
            }
            return ((Reference[])((UnorderedCollection)UnorderedCollection.this).storage.array)[this.index++];
        }

        @Override
        public void remove() {
            UnorderedCollection.this.remove(--this.index);
        }
    }

    private static class Reference<E>
    implements ElementReference {
        public E element;
        public int index;

        Reference(E element, int index) {
            this.element = element;
            this.index = index;
        }
    }
}

