/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.simple;

import java.util.function.IntFunction;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.simple.SimpleAutomaton;
import net.automatalib.ts.simple.SimpleDTS;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SimpleDeterministicAutomaton<S, I>
extends SimpleAutomaton<S, I>,
SimpleDTS<S, I> {
    default public FullIntAbstraction fullIntAbstraction(Alphabet<I> alphabet) {
        return this.fullIntAbstraction(alphabet.size(), alphabet);
    }

    default public FullIntAbstraction fullIntAbstraction(int numInputs, IntFunction<? extends I> symMapping) {
        return new FullIntAbstraction.DefaultAbstraction<I, StateIntAbstraction<I>>(this.stateIntAbstraction(), numInputs, symMapping);
    }

    default public StateIntAbstraction<I> stateIntAbstraction() {
        return new StateIntAbstraction.DefaultAbstraction(this);
    }

    public static interface FullIntAbstraction
    extends IntAbstraction {
        public int getSuccessor(int var1, int var2);

        public int numInputs();

        public static class DefaultAbstraction<I, A extends StateIntAbstraction<I>>
        implements FullIntAbstraction {
            protected final A stateAbstraction;
            protected final int numInputs;
            protected final IntFunction<? extends I> symMapping;

            public DefaultAbstraction(A stateAbstraction, int numInputs, IntFunction<? extends I> symMapping) {
                this.stateAbstraction = stateAbstraction;
                this.numInputs = numInputs;
                this.symMapping = symMapping;
            }

            @Override
            public int getSuccessor(int state, int input) {
                return this.stateAbstraction.getSuccessor(state, this.intToSym(input));
            }

            @Override
            public int numInputs() {
                return this.numInputs;
            }

            protected final I intToSym(int input) {
                return this.symMapping.apply(input);
            }

            @Override
            public int size() {
                return this.stateAbstraction.size();
            }

            @Override
            public int getIntInitialState() {
                return this.stateAbstraction.getIntInitialState();
            }
        }
    }

    public static interface StateIntAbstraction<I>
    extends IntAbstraction {
        public int getSuccessor(int var1, I var2);

        public static class DefaultAbstraction<S, I, A extends SimpleDeterministicAutomaton<S, I>>
        extends IntAbstraction.DefaultAbstraction<S, A>
        implements StateIntAbstraction<I> {
            public DefaultAbstraction(A automaton) {
                super(automaton);
            }

            @Override
            public int getSuccessor(int state, I input) {
                return this.safeStateToInt(this.automaton.getSuccessor(this.intToState(state), input));
            }
        }
    }

    public static interface IntAbstraction {
        public static final int INVALID_STATE = -1;

        public int size();

        public int getIntInitialState();

        public static class DefaultAbstraction<S, A extends SimpleDeterministicAutomaton<S, ?>>
        implements IntAbstraction {
            protected final A automaton;
            protected final StateIDs<S> stateIds;

            public DefaultAbstraction(A automaton) {
                this.automaton = automaton;
                this.stateIds = automaton.stateIDs();
            }

            @Override
            public int size() {
                return this.automaton.size();
            }

            protected final S intToState(int stateId) {
                return this.stateIds.getState(stateId);
            }

            protected final @Nullable S safeIntToState(int stateId) {
                return stateId == -1 ? null : (S)this.intToState(stateId);
            }

            @Override
            public int getIntInitialState() {
                return this.safeStateToInt(this.automaton.getInitialState());
            }

            protected final int stateToInt(S state) {
                return this.stateIds.getStateId(state);
            }

            protected final int safeStateToInt(@Nullable S state) {
                return state == null ? -1 : this.stateToInt(state);
            }
        }
    }
}

