/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.HITSWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import edu.uci.ics.jung.graph.Graph;

public class HITS<V, E>
extends HITSWithPriors<V, E> {
    public HITS(Graph<V, E> g2, Function<E, Double> edge_weights, double alpha) {
        super(g2, edge_weights, ScoringUtils.getHITSUniformRootPrior(g2.getVertices()), alpha);
    }

    public HITS(Graph<V, E> g2, double alpha) {
        super(g2, ScoringUtils.getHITSUniformRootPrior(g2.getVertices()), alpha);
    }

    public HITS(Graph<V, E> g2) {
        this(g2, 0.0);
    }

    public static class Scores {
        public double hub;
        public double authority;

        public Scores(double hub, double authority) {
            this.hub = hub;
            this.authority = authority;
        }

        public String toString() {
            return String.format("[h:%.4f,a:%.4f]", this.hub, this.authority);
        }
    }
}

