/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.fa.XFAFileFilter;
import de.renew.fa.service.XFAFormat;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.ioontology.importing.ImportFormatAbstract;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XFAImportFormat
extends ImportFormatAbstract<Drawing>
implements ImportFormat<Drawing> {
    public XFAImportFormat() {
        super("XFA", (FileFilter)new XFAFileFilter());
    }

    protected List<Drawing> importFile(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }
        FileInputStream stream = new FileInputStream(new File(file.getFile()));
        XFAFormat format = new XFAFormat();
        List<Drawing> result = format.parse(stream, StringUtil.getFilename((String)file.getPath()));
        stream.close();
        return result;
    }

    public List<Drawing> importFiles(URL[] paths) throws Exception {
        ArrayList<Drawing> list = new ArrayList<Drawing>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            URL url = paths[i];
            list.addAll(this.importFile(url));
        }
        return list;
    }
}

