/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.fa.FADrawing;
import de.renew.fa.model.Arc;
import de.renew.fa.model.FA;
import de.renew.fa.model.FAImpl;
import de.renew.fa.model.Letter;
import de.renew.fa.model.State;
import de.renew.fa.model.Word;
import de.renew.fa.util.FAHelper;
import de.renew.gui.GuiPlugin;
import de.renew.util.StringUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class FAFileParser {
    private static final Logger LOGGER = Logger.getLogger(FAFileParser.class);
    protected String _fileName;

    public static void writeToXFA(OutputStream stream, FA fa) {
        block2: {
            Properties properties = FAHelper.toProperties(fa);
            try {
                properties.store(stream, "FA Model for Drawing: " + fa.getName());
            }
            catch (IOException e) {
                LOGGER.error((Object)(FAFileParser.class.getName() + ": Could not write fa " + fa.getName() + " to file."));
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug((Object)(FAFileParser.class.getName() + ": "), (Throwable)e);
            }
        }
    }

    public static void writeToXFA(OutputStream stream, Drawing drawing) {
        if (drawing instanceof FADrawing) {
            FADrawing faDrawing = (FADrawing)drawing;
            FA fa = FAHelper.getModel(faDrawing);
            FAFileParser.writeToXFA(stream, fa);
            String latexCode = FAFileParser.getLatexCode(fa);
            FAFileParser.producepdf(latexCode, fa.getName());
        }
    }

    private static void producepdf(String latexCode, String name) {
        File file = null;
        try {
            file = File.createTempFile(name, ".tex");
            PrintWriter pw = new PrintWriter(file);
            pw.write("\\documentclass[a4paper]{article}");
            pw.write("\\begin{document}");
            pw.write(latexCode);
            pw.write("\\end{document}");
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file != null && file.exists()) {
            String[] command = new String[]{"pdflatex", "-output-directory=" + file.getAbsoluteFile().getParent(), file.getAbsolutePath()};
            FAFileParser.runCommand(command);
            String pdffile = StringUtil.extendFileNameBy((String)file.getAbsolutePath(), (String)"pdf");
            try {
                Desktop.getDesktop().browse(new URI("file://" + pdffile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private static final int runCommand(String[] command) {
        int exitCode = 0;
        StringBuffer com = new StringBuffer();
        for (int i = 0; i < command.length; ++i) {
            if (i > 0) {
                com.append(' ');
            }
            com.append(command[i]);
        }
        System.out.println("running command: " + com.toString());
        Process exec = null;
        try {
            exec = Runtime.getRuntime().exec(command);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (exec != null) {
            try {
                exitCode = exec.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return exitCode;
    }

    private static String getLatexCode(FA fa) {
        StringBuffer result = new StringBuffer();
        if (LOGGER.isInfoEnabled()) {
            State state;
            State state2;
            Letter letter;
            State state3;
            LOGGER.info((Object)(FAFileParser.class.getName() + ": "));
            result.append("\\newcommand{\\faname}{A}\n");
            result.append("\\begin{eqnarray*}\n");
            result.append("\\faname &:=& (Q,\\Sigma,\\delta,S_{0},F) \\\\\n");
            result.append("Q &:=& \\{");
            Iterator<State> states = fa.getStates();
            if (states.hasNext()) {
                state3 = states.next();
                result.append(FAFileParser.texify(state3.getName()));
            }
            while (states.hasNext()) {
                state3 = states.next();
                result.append("," + FAFileParser.texify(state3.getName()));
            }
            result.append("\\} \\\\\n");
            result.append("\\Sigma&:=&\\{");
            Iterator<Letter> alphabet = fa.getAlphabet();
            if (alphabet.hasNext()) {
                letter = alphabet.next();
                result.append(letter.getName());
            }
            while (alphabet.hasNext()) {
                letter = alphabet.next();
                result.append("," + letter.getName());
            }
            result.append("\\} \\\\\n");
            result.append("S_{0}&:=&\\{");
            Iterator<State> iterator = fa.startStates().iterator();
            if (iterator.hasNext()) {
                state2 = iterator.next();
                result.append(FAFileParser.texify(state2.getName()));
            }
            while (iterator.hasNext()) {
                state2 = iterator.next();
                result.append("," + FAFileParser.texify(state2.getName()));
            }
            result.append("\\} \\\\\n");
            result.append("F&:=&\\{");
            Iterator<State> endstates = fa.endStates().iterator();
            if (endstates.hasNext()) {
                state = endstates.next();
                result.append(FAFileParser.texify(state.getName()));
            }
            while (endstates.hasNext()) {
                state = endstates.next();
                result.append("," + FAFileParser.texify(state.getName()));
            }
            result.append("\\} \\\\\n");
            HashMap map = new HashMap();
            Iterator<State> states2 = fa.getStates();
            while (states2.hasNext()) {
                State state4 = states2.next();
                map.put(state4, new HashMap());
                Iterator<Letter> alphabet2 = fa.getAlphabet();
                while (alphabet2.hasNext()) {
                    Letter letter2 = alphabet2.next();
                    Vector<State> images = new Vector<State>();
                    ((HashMap)map.get(state4)).put(letter2, images);
                    Iterator<Arc> arcs = fa.getArcs();
                    while (arcs.hasNext()) {
                        Arc arc = arcs.next();
                        if (!state4.equals(arc.getFrom()) || !arc.getInscription().toString().contains(letter2.getName())) continue;
                        images.add(arc.getTo());
                    }
                    if (images.isEmpty()) continue;
                    result.append("\\delta(" + FAFileParser.texify(state4.getName()) + "," + String.valueOf(letter2) + ")&:=& \\{");
                    boolean check = false;
                    for (State state22 : images) {
                        if (check) {
                            result.append("," + FAFileParser.texify(state22.getName()));
                            continue;
                        }
                        result.append(FAFileParser.texify(state22.getName()));
                        check = true;
                    }
                    result.append("\\} \\\\\n");
                }
            }
            result.append("\\end{eqnarray*}\n");
            result.append("$$\\delta:=\\bordermatrix{\n");
            Iterator<Letter> alphabet3 = fa.getAlphabet();
            result.append("     ");
            while (alphabet3.hasNext()) {
                Letter letter3 = alphabet3.next();
                result.append(" & " + letter3.getName());
            }
            result.append(" \\cr\n");
            Iterator<State> states3 = fa.getStates();
            while (states3.hasNext()) {
                State state5 = states3.next();
                result.append(FAFileParser.texify(state5.getName()));
                Iterator<Letter> alphabet2 = fa.getAlphabet();
                while (alphabet2.hasNext()) {
                    Letter letter2 = alphabet2.next();
                    Iterator iterator2 = ((Vector)((HashMap)map.get(state5)).get(letter2)).iterator();
                    result.append(" & \\{");
                    while (iterator2.hasNext()) {
                        State state23 = (State)iterator2.next();
                        result.append(" " + FAFileParser.texify(state23.getName()) + " ");
                    }
                    result.append("\\} ");
                }
                result.append(" \\cr\n");
            }
            result.append("}.$$\n");
        }
        return result.toString();
    }

    private static String texify(String s) {
        return s.replaceAll("(\\w)([\\d]+)", "$1_{$2}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Arc newArc(FA fa, String token) {
        StringTokenizer st = new StringTokenizer(token, "(:) ");
        State from = null;
        Word inscription = null;
        State to = null;
        if (!st.hasMoreTokens()) return null;
        String subtoken = st.nextToken();
        from = fa.getStateByName(subtoken);
        if (!st.hasMoreTokens()) return null;
        subtoken = st.nextToken();
        if (st.hasMoreTokens()) {
            if ("lambda".equals(subtoken)) {
                subtoken = "";
            }
            inscription = fa.newWord(subtoken);
            subtoken = st.nextToken();
            to = fa.getStateByName(subtoken);
        } else {
            inscription = fa.newWord("");
            to = fa.getStateByName(subtoken);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(FAFileParser.class.getName() + ": " + String.valueOf(from) + String.valueOf(inscription) + String.valueOf(to)));
        }
        if (from == null) return null;
        if (inscription == null) return null;
        if (to != null) return fa.newArc(from, inscription, to);
        return null;
    }

    private FA parseXFA(InputStream stream) {
        Properties elements = new Properties();
        try {
            elements.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FAImpl fa = new FAImpl();
        String states = (String)elements.get("Z");
        StringTokenizer st = new StringTokenizer(states, "[,] ");
        while (st.hasMoreElements()) {
            String stateName = (String)st.nextElement();
            fa.newState(stateName);
        }
        String sigma = (String)elements.get("Sigma");
        st = new StringTokenizer(sigma, "[,] ");
        while (st.hasMoreElements()) {
            String letterName = (String)st.nextElement();
            if (letterName.length() == 1) {
                fa.newLetter(letterName);
                continue;
            }
            String message = "Element \"" + letterName + "\" is not a single character. Ignoring element.";
            String title = "Ignoring element";
            this.simpleMessage(title, message);
        }
        String arcs = (String)elements.get("K");
        st = new StringTokenizer(arcs, "[,] ");
        while (st.hasMoreElements()) {
            String arcName = (String)st.nextElement();
            if (this.newArc(fa, arcName) != null) continue;
            this.simpleMessage("Ignoring Arc", arcName + " is not a valid arc name.");
        }
        String startStates = (String)elements.get("Z_Start");
        st = new StringTokenizer(startStates, "[,] ");
        while (st.hasMoreElements()) {
            String ssName = (String)st.nextElement();
            if (fa.getStateByName(ssName) != null) {
                fa.getStateByName(ssName).setStartState(true);
                continue;
            }
            this.simpleMessage("Ignoring start state attribute", ssName + " is not in the set of states.");
        }
        String endStates = (String)elements.get("Z_End");
        st = new StringTokenizer(endStates, "[,] ");
        while (st.hasMoreElements()) {
            String esName = (String)st.nextElement();
            if (fa.getStateByName(esName) != null) {
                fa.getStateByName(esName).setEndState(true);
                continue;
            }
            this.simpleMessage("Ignoring end state attribute", esName + " is not in the set of states.");
        }
        return fa;
    }

    public FA parseXFA(InputStream stream, String name) {
        FA fa = this.parseXFA(stream);
        fa.setName(StringUtil.stripFilenameExtension((String)name));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(FAFileParser.class.getName() + "------ FA Check Name1: " + fa.getName() + " ----------------------------\n\n" + fa.toString()));
        }
        return fa;
    }

    public FA parseXFA(String fileName) {
        FA fa = new FAImpl();
        try {
            FileInputStream in = new FileInputStream(fileName);
            fa = this.parseXFA(in);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        fa.setName(StringUtil.stripFilenameExtension((String)fileName));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(FAFileParser.class.getName() + "------ FA Check Name2: " + fa.getName() + " ----------------------------\n\n" + fa.toString()));
        }
        return fa;
    }

    private void simpleMessage(String title, String message) {
        GuiPlugin gui = GuiPlugin.getCurrent();
        if (gui == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(FAFileParser.class.getName() + ": " + title + ": " + message));
            }
            return;
        }
        JOptionPane.showMessageDialog(gui.getGuiFrame(), message, title, 2, new ImageIcon(gui.getClass().getResource("/de/renew/gui/images/RENEW.gif")));
    }

    public static void main(String[] args) {
        String s = "z001aaa44";
        System.out.println(s.replaceAll("(\\w)([\\d]+)", "$1_{$2}"));
    }
}

