/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.gui;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.io.DrawingFileHelper;
import de.renew.fa.FADrawing;
import de.renew.fa.service.AutomataComparator;
import de.renew.fa.util.FAHelper;
import de.renew.faformalism.util.FASyntaxChecker;
import de.renew.ioontology.FileFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FACompareGui {
    private final JFrame _frame;
    private final JPanel _leftPanel;
    private final Set<FADrawing> _rightDrawings = new HashSet<FADrawing>();
    private boolean _regexSelected = false;
    private JTextField _regexInputField;
    private final JButton _leftSwitchButton;
    private final JButton _changeDrawingButton;
    private final JButton _compareButton;
    private final JButton _addButtonRight;
    private final JButton _removeAllButton;
    private FADrawing _leftDrawing;
    private final ActionListener _changeDrawingButtonListener;
    private final ActionListener _leftSwitchButtonListener;
    private final ActionListener _compareButtonListener;
    private final ActionListener _addRightButtonListener;
    private final ActionListener _removeAllButtonListener;

    public FACompareGui() {
        this._frame = new JFrame("Compare Automata");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        this._leftPanel = new JPanel();
        this._leftPanel.setLayout(new BoxLayout(this._leftPanel, 1));
        this._changeDrawingButton = new JButton("Change Drawing");
        this._changeDrawingButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                chooser.setFileFilter(IOHelper.mapToSwingFileFilter((FileFilter)DrawingTypeManager.getInstance().getFilter("de.renew.fa.FADrawing")));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setMultiSelectionEnabled(false);
                int success = chooser.showOpenDialog(null);
                if (success != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                JLabel drawingName = new JLabel(file.getName());
                drawingName.setHorizontalAlignment(0);
                FACompareGui.this._leftDrawing = (FADrawing)DrawingFileHelper.loadDrawing((File)file, message -> {});
                FACompareGui.this._leftPanel.remove(0);
                FACompareGui.this._leftPanel.add((Component)drawingName, 0);
                FACompareGui.this._frame.revalidate();
                FACompareGui.this._frame.pack();
                FACompareGui.this._frame.repaint();
            }
        };
        this._changeDrawingButton.addActionListener(this._changeDrawingButtonListener);
        JLabel defaultText = new JLabel("No drawing selected");
        this._leftPanel.add(defaultText);
        this._leftPanel.add(this._changeDrawingButton);
        final String toRegEx = "Switch to RegEx";
        final String toDrawing = "Switch to Drawing";
        this._leftSwitchButton = new JButton(toRegEx);
        this._leftSwitchButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FACompareGui.this._regexSelected) {
                    FACompareGui.this._leftSwitchButton.setText(toRegEx);
                    FACompareGui.this._leftPanel.remove(0);
                    FACompareGui.this._leftPanel.add((Component)new JLabel("No Drawing selected!"), 0);
                    FACompareGui.this._leftPanel.add((Component)FACompareGui.this._changeDrawingButton, 1);
                } else {
                    FACompareGui.this._leftSwitchButton.setText(toDrawing);
                    FACompareGui.this._leftPanel.remove(0);
                    FACompareGui.this._leftPanel.remove(0);
                    FACompareGui.this._regexInputField = new JTextField();
                    FACompareGui.this._regexInputField.setHorizontalAlignment(0);
                    FACompareGui.this._leftPanel.add((Component)FACompareGui.this._regexInputField, 0);
                }
                FACompareGui.this._regexSelected = !FACompareGui.this._regexSelected;
            }
        };
        this._leftSwitchButton.addActionListener(this._leftSwitchButtonListener);
        this._leftPanel.add(this._leftSwitchButton);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        this._compareButton = new JButton("Compare");
        this._compareButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FACompareGui.this._regexSelected) {
                    String input = FACompareGui.this._regexInputField.getText().replace(" ", "");
                    try {
                        FASyntaxChecker.checkNFAWordSyntax((String)input);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                    FACompareGui.this._leftDrawing = (FADrawing)FAHelper.convertModelToDrawing(FAHelper.regexToNfa(input));
                }
                for (FADrawing rightDrawing : FACompareGui.this._rightDrawings) {
                    String[] separatingWord = AutomataComparator.nfaLanguageEquivalence(FACompareGui.this._leftDrawing, rightDrawing);
                    Object suffix = "Equal!";
                    if (separatingWord != null) {
                        String notAcceptedBy;
                        if (separatingWord[1].equals("")) {
                            separatingWord[1] = "epsilon";
                        }
                        if (separatingWord[0].equals(notAcceptedBy = rightDrawing.getName())) {
                            notAcceptedBy = "Template";
                        }
                        suffix = "Not Equal!\n    " + separatingWord[0] + " accepts \"" + separatingWord[1] + "\"\n    But " + notAcceptedBy + " does not!";
                    }
                    System.out.println("Comparing " + rightDrawing.getName() + " : " + (String)suffix);
                }
            }
        };
        this._compareButton.addActionListener(this._compareButtonListener);
        centerPanel.add(this._compareButton);
        final JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        this._addButtonRight = new JButton("Add Drawing");
        this._addRightButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files;
                JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                chooser.setFileFilter(IOHelper.mapToSwingFileFilter((FileFilter)DrawingTypeManager.getInstance().getFilter("de.renew.fa.FADrawing")));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setMultiSelectionEnabled(true);
                int success = chooser.showOpenDialog(null);
                if (success != 0) {
                    return;
                }
                for (File f : files = chooser.getSelectedFiles()) {
                    FADrawing faDrawing = (FADrawing)DrawingFileHelper.loadDrawing((File)f, message -> {});
                    FACompareGui.this._rightDrawings.add(faDrawing);
                    JLabel newName = new JLabel(f.getName());
                    newName.setHorizontalAlignment(0);
                    rightPanel.add((Component)newName, rightPanel.getComponentCount() - 1);
                }
                FACompareGui.this._frame.revalidate();
                FACompareGui.this._frame.pack();
                FACompareGui.this._frame.repaint();
            }
        };
        this._addButtonRight.addActionListener(this._addRightButtonListener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this._addButtonRight);
        this._removeAllButton = new JButton("Remove All");
        this._removeAllButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = rightPanel.getComponentCount() - 2; i > -1; --i) {
                    rightPanel.remove(i);
                }
                FACompareGui.this._rightDrawings.clear();
                FACompareGui.this._frame.revalidate();
                FACompareGui.this._frame.pack();
                FACompareGui.this._frame.repaint();
            }
        };
        this._removeAllButton.addActionListener(this._removeAllButtonListener);
        buttonPanel.add(this._removeAllButton);
        rightPanel.add(buttonPanel);
        mainPanel.add(this._leftPanel);
        mainPanel.add(centerPanel);
        mainPanel.add(rightPanel);
        this._frame.add(mainPanel);
    }

    public void showGui() {
        this._frame.setVisible(true);
        this._frame.setState(0);
        this._frame.pack();
        this._frame.setVisible(true);
    }

    public void cleanup() {
        this._changeDrawingButton.removeActionListener(this._changeDrawingButtonListener);
        this._leftSwitchButton.removeActionListener(this._leftSwitchButtonListener);
        this._compareButton.removeActionListener(this._compareButtonListener);
        this._addButtonRight.removeActionListener(this._addRightButtonListener);
        this._removeAllButton.removeActionListener(this._removeAllButtonListener);
        SwingUtilities.invokeLater(this._frame::dispose);
    }
}

