/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.fa.figures.FADrawMode;
import de.renew.fa.figures.FigureDecoration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class StartDecoration
implements FigureDecoration {
    private static final int DEFAULT_SIZE = 20;
    static final long serialVersionUID = -7256841995889060220L;
    protected int _halfSize;
    protected int _size;

    public static int getDefaultSize() {
        return 20;
    }

    @Override
    public void draw(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (FADrawMode.getInstance().getMode() == 0) {
            this.drawStandard(g, r, fillColor, lineColor);
        } else {
            this.drawAlternative(g, r, fillColor, lineColor);
        }
    }

    public void drawStandard(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (!ColorMap.isTransparent((Color)lineColor)) {
            g.setColor(lineColor);
            g.fillArc(r.x, r.y, r.width - 1, r.height - 1, 120, 120);
            if (!ColorMap.isTransparent((Color)fillColor)) {
                g.setColor(fillColor);
            } else {
                g.setColor(Color.WHITE);
            }
            g.fillRect(this.getXabs(r) + r.width / 4, this.getYabs(r) + 2, Double.valueOf(r.width / 2).intValue(), Double.valueOf(this.getYprime(r) * 2.0).intValue() - 1);
        }
    }

    public void drawAlternative(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (!ColorMap.isTransparent((Color)lineColor)) {
            g.setColor(lineColor);
            int size = 5;
            int[] xPoints = new int[size];
            int[] yPoints = new int[size];
            xPoints[0] = r.x;
            yPoints[0] = r.y;
            Point p = Geom.ovalAngleToPoint((Rectangle)r, (double)3.92625);
            p.translate(-1, -1);
            xPoints[1] = p.x;
            yPoints[1] = p.y;
            xPoints[2] = p.x - 8;
            yPoints[2] = p.y + 2;
            xPoints[3] = p.x + 2;
            yPoints[3] = p.y - 8;
            xPoints[4] = p.x;
            yPoints[4] = p.y;
            g.drawPolyline(xPoints, yPoints, size);
        }
    }

    @Override
    public boolean equals(FigureDecoration fd) {
        return fd instanceof StartDecoration;
    }

    private int getXabs(Rectangle r) {
        return r.x;
    }

    private int getYabs(Rectangle r) {
        float b = r.height / 2;
        return Double.valueOf((double)((float)r.y + b) - this.getYprime(r)).intValue();
    }

    private double getYprime(Rectangle r) {
        float b = r.height / 2;
        return Math.sqrt(0.75 * (double)b * (double)b);
    }

    public void read(StorableInput dr) throws IOException {
    }

    public void write(StorableOutput dw) {
    }
}

