/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAConnectionHandle;
import de.renew.fa.figures.FAStateInstanceFigure;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.fa.figures.FigureDecoration;
import de.renew.fa.figures.NullDecoration;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.faformalism.shadow.ShadowFAState;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.InscribableFigure;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.NodeFigure;
import de.renew.gui.SimulableFigure;
import de.renew.remote.ObjectAccessor;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FAStateFigure
extends EllipseFigure
implements InscribableFigure,
FigureWithHighlight,
NodeFigure,
SimulableFigure {
    public static final Logger LOGGER = Logger.getLogger(FAStateFigure.class);
    private static final FAArcConnection ANCHOR = new FAArcConnection(null, null, "");
    public static final int NULL = 0;
    public static final int START = 1;
    public static final int END = 2;
    public static final int STARTEND = 3;
    public static final int HIGHLIGHT = 0;
    public static final int CARDINALITY = 1;
    public static final int TOKENS = 2;
    public static final int EXPANDED_TOKENS = 3;
    static final long serialVersionUID = 6652986258188946097L;
    private transient ShadowFAState _shadow = null;
    private FigureDecoration _decoration = new NullDecoration();
    private Figure _hilightFig = null;
    private FAWordTextFigure _word = null;

    public FAStateFigure() {
        this.setDecoration(new NullDecoration());
        ANCHOR.setFrameColor(this.getFrameColor());
        ANCHOR.setAttribute("LineShape", 1);
        ANCHOR.setAttribute("BSplineSegments", 15);
        ANCHOR.setEndDecoration((LineDecoration)new ArrowTip());
    }

    public boolean isStartState() {
        return this._decoration instanceof StartDecoration || this._decoration instanceof StartEndDecoration;
    }

    public boolean isEndState() {
        return this._decoration instanceof EndDecoration || this._decoration instanceof StartEndDecoration;
    }

    public void addChild(ChildFigure child) {
        if (child instanceof FAWordTextFigure) {
            FAWordTextFigure word = (FAWordTextFigure)child;
            if (!this.isStartState()) {
                return;
            }
            if (this._word != null) {
                this._word.figureRemoved(StorableApi.createFigureChangeEvent((Figure)this._word));
            }
            this._word = word;
        } else {
            super.addChild(child);
        }
    }

    public ShadowNetElement buildShadow(ShadowNet net) {
        LOGGER.debug((Object)("buildShadow(Shadownet) called by " + String.valueOf((Object)this)));
        if (this._shadow != null) {
            this._shadow.discard();
        }
        this._shadow = new ShadowFAState(net);
        this._shadow.setContext((Object)this);
        this._shadow._stateType = this.getStateType();
        this._shadow.setID(this.getID());
        this._shadow.setTrace(this.getTraceMode());
        if (this.isStartState() && this._word != null) {
            this._shadow._word = this._word.getText();
        } else if (this.isStartState()) {
            this._shadow._word = " ";
        }
        LOGGER.debug((Object)("built " + String.valueOf(this._shadow)));
        return this._shadow;
    }

    public int getStateType() {
        return this._decoration instanceof NullDecoration ? 0 : (this._decoration instanceof StartDecoration ? 1 : (this._decoration instanceof EndDecoration ? 2 : 3));
    }

    public ShadowNetElement getShadow() {
        return this._shadow;
    }

    public InstanceFigure createInstanceFigure(InstanceDrawing drawing, Hashtable<Serializable, ObjectAccessor> netElements) {
        return new FAStateInstanceFigure(drawing, this, netElements);
    }

    public static Dimension defaultDimension() {
        return new Dimension(40, 40);
    }

    private void decorate(Graphics g) {
        if (this._decoration != null) {
            this._decoration.draw(g, this.displayBox(), this.getFillColor(), this.getFrameColor());
        }
    }

    public FigureDecoration getDecoration() {
        return this._decoration;
    }

    public void internalDraw(Graphics g) {
        super.internalDraw(g);
        this.decorate(g);
    }

    public void setDecoration(FigureDecoration decoration) {
        if (decoration == null) {
            this._decoration = new NullDecoration();
            return;
        }
        this._decoration = decoration;
        if (!(this._decoration instanceof StartDecoration) && !(this._decoration instanceof StartEndDecoration) && this._word != null) {
            this._word.figureRemoved(StorableApi.createFigureChangeEvent((Figure)this._word));
        }
    }

    public void setHighlightFigure(Figure fig) {
        this._hilightFig = fig;
    }

    public Vector<FigureHandle> handles() {
        Vector handles = super.handles();
        handles.addElement(new FAConnectionHandle((Figure)this, RelativeLocator.center(), ANCHOR));
        return handles;
    }

    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration superDep = super.getFiguresWithDependencies();
        Vector<Figure> myDep = new Vector<Figure>(1);
        myDep.addElement(this.getHighlightFigure());
        return new MergedFigureEnumerator(superDep, (FigureEnumeration)new FigureEnumerator(myDep));
    }

    public Figure getHighlightFigure() {
        return this._hilightFig;
    }

    public int getMarkingAppearance() {
        Object value = this.getAttribute("MarkingAppearance");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public boolean getTraceMode() {
        Object value = this.getAttribute("TraceMode");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        if (dr.getVersion() >= 3) {
            this.setHighlightFigure((Figure)dr.readStorable());
        }
        this._decoration = (FigureDecoration)dr.readStorable();
        dr.readString();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this._hilightFig);
        dw.writeStorable((Storable)this._decoration);
        if (this._decoration != null) {
            dw.writeString(this._decoration.getClass().getName());
        } else {
            dw.writeString(NullDecoration.class.getName());
        }
    }

    public String getName() {
        String cln = ((Object)((Object)this)).getClass().getName();
        int ind = cln.lastIndexOf(46) + 1;
        if (ind > 0) {
            cln = cln.substring(ind);
        }
        FigureEnumeration children = this.children();
        while (children.hasMoreElements()) {
            FATextFigure textFig;
            Figure child = (Figure)children.nextElement();
            if (!(child instanceof FATextFigure) || (textFig = (FATextFigure)child).getType() != 2) continue;
            return cln + " \"" + textFig.getText() + "\"";
        }
        return cln + " (" + this.getID() + ")";
    }

    public void removeChild(ChildFigure child) {
        if (child == this._word) {
            this._word = null;
        }
        super.removeChild(child);
    }

    public void release() {
        this.setHighlightFigure(null);
        super.release();
        if (this._shadow != null) {
            this._shadow.discard();
        }
        if (this._word != null) {
            this._word.release();
        }
    }

    public String toString() {
        return this.getName();
    }
}

