/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.api.CommandApi;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.MenuSeparatorFactory;
import de.renew.fa.AltPaletteCreator;
import de.renew.fa.FADrawing;
import de.renew.fa.FAFileFilter;
import de.renew.fa.FAPluginExtender;
import de.renew.fa.PaletteCreator;
import de.renew.fa.commands.ChangeDecorationCommand;
import de.renew.fa.commands.ChangeFADrawModeCommand;
import de.renew.fa.commands.ShowComparatorCommand;
import de.renew.fa.commands.ShowPaletteCommand;
import de.renew.fa.commands.ShowSettingsCommand;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FADrawMode;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.NullDecoration;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.fa.gui.FACompareGui;
import de.renew.fa.gui.FASimulationSettingsDelegator;
import de.renew.fa.gui.FASimulationSettingsInterface;
import de.renew.fa.service.JflapExportFormat;
import de.renew.fa.service.XFAExportFormat;
import de.renew.fa.service.XFAImportFormat;
import de.renew.faformalism.util.FAAutomatonModelEnum;
import de.renew.faformalism.util.SimulationSettingsManager;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InscribableFigure;
import de.renew.gui.TextFigureCreator;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;
import de.renew.propertymanagement.prop.PropertyChangeEvent;
import de.renew.propertymanagement.prop.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FAPlugin
extends PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(FAPlugin.class);
    private static final String KEY_USEINDICES = "de.renew.fa.useindices";
    private static final String KEY_STATE_PREFIX = "de.renew.fa.state-prefix";
    private static final String KEY_MODE = "de.renew.fa.mode";
    private static final String KEY_INIT = "de.renew.fa.init";
    private static final String ALTERNATIVE_EVENT = "alternative";
    private Hashtable<AbstractCommand, IPlugin> _commandList;
    private Vector<IPlugin> _pluginList;
    private CommandMenu _menu;
    private JMenuItem _separator;
    private FAFigureCreator _faFigureCreator = null;
    private boolean _loaded;
    private FormalismChangeListener _formalismListener;
    private PaletteCreator _pc;
    private final XFAImportFormat _xfaImportFormat = new XFAImportFormat();
    private final XFAExportFormat _xfaExportFormat = new XFAExportFormat();
    private final JflapExportFormat _jflapExportFormat = new JflapExportFormat();
    private FASimulationSettingsInterface _settingsMenu;
    private FACompareGui _compareGui;
    public static final String FA_FILEFILTER = "de.renew.fa.FADrawing";
    private PropertyChangeListener _propertyChangeListener;

    public FAPlugin(PluginProperties props) {
        super(props);
        this._pluginList = new Vector();
        this._commandList = new Hashtable();
    }

    public FAPlugin(URL location) throws PluginException {
        super(location);
        this._pluginList = new Vector();
        this._commandList = new Hashtable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        String pluginName = this.getName();
        String displayNameInit = "Load FA Palette on start-up";
        String displayNameMode = "Change FA Style";
        String displayNameUseIndices = "Toggle Indices On/Off";
        String displayNameStatePrefix = "Standard Name of State";
        String[] booleanChoices = new String[]{"true", "false"};
        String[] selectionChoicesMode = new String[]{ALTERNATIVE_EVENT, "standard"};
        String defaultValueInit = this.getProperties().getProperty(KEY_INIT);
        String defaultValueMode = this.getProperties().getProperty(KEY_MODE);
        String defaultValueUseindices = this.getProperties().getProperty(KEY_USEINDICES);
        String defaultValueStatePrefix = this.getProperties().getProperty(KEY_STATE_PREFIX);
        ConfigurablePropertyManager propertyManager = ConfigurablePropertyManager.getInstance();
        propertyManager.addConfigurableProperty(KEY_INIT, defaultValueInit, pluginName, displayNameInit, booleanChoices);
        propertyManager.addConfigurableProperty(KEY_MODE, defaultValueMode, pluginName, displayNameMode, selectionChoicesMode);
        propertyManager.addConfigurableProperty(KEY_USEINDICES, defaultValueUseindices, pluginName, displayNameUseIndices, booleanChoices);
        propertyManager.addConfigurableProperty(KEY_STATE_PREFIX, defaultValueStatePrefix, pluginName, displayNameStatePrefix, null);
        DrawPlugin gs = DrawPlugin.getCurrent();
        this._settingsMenu = new FASimulationSettingsDelegator();
        this._compareGui = new FACompareGui();
        this._menu = this.createMenu();
        this._propertyChangeListener = new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                switch (event.getProperty()) {
                    case "de.renew.fa.mode": {
                        FADrawMode mode = FADrawMode.getInstance();
                        if (FAPlugin.ALTERNATIVE_EVENT.equals(event.getNewValue())) {
                            mode.setMode(1);
                            break;
                        }
                        mode.setMode(0);
                        break;
                    }
                    case "de.renew.fa.useindices": {
                        FAPlugin.this.getProperties().setProperty(FAPlugin.KEY_USEINDICES, event.getNewValue());
                        DrawingEditor editor = DrawPlugin.getCurrent().getDrawingEditor();
                        FigureEnumeration en = editor.drawing().figures();
                        while (en.hasMoreElements()) {
                            Figure fig = en.nextFigure();
                            fig.changed();
                        }
                        editor.view().checkDamage();
                        break;
                    }
                    case "de.renew.fa.state-prefix": {
                        FAPlugin.this.getProperties().setProperty(FAPlugin.KEY_STATE_PREFIX, event.getNewValue());
                        break;
                    }
                    case "de.renew.fa.init": {
                        FAPlugin.this.getProperties().setProperty(FAPlugin.KEY_INIT, event.getNewValue());
                    }
                }
            }

            public void propertyAdded(PropertyChangeEvent event) {
            }

            public void propertyRemoved(PropertyChangeEvent event) {
            }
        };
        propertyManager.addPropertyChangeListener(this._propertyChangeListener);
        CPNInstanceDrawing.registerInstanceDrawingFactory(FADrawing.class, CPNInstanceDrawing::new);
        if (gs != null) {
            MenuSeparatorFactory sepFac = MenuApi.createMenuSeparatorFactory((String)"de.renew.fa");
            this._separator = sepFac.createSeparator();
            MenuApi.registerMenu((String)"Tools", (JMenuItem)this._separator);
            MenuApi.registerMenu((String)"Tools", (JMenuItem)this._menu);
            this._faFigureCreator = new FAFigureCreator();
            GuiPlugin.getCurrent().getFigureCreatorHolder().registerCreator((TextFigureCreator)this._faFigureCreator);
            if (gs != null) {
                DrawingTypeManager.getInstance().register(FA_FILEFILTER, (ExtensionFileFilter)new FAFileFilter());
            }
            try {
                boolean init = PropertyHelper.getBoolProperty((Properties)this.getProperties(), (String)KEY_INIT);
                LOGGER.debug((Object)("init protperty is : " + init));
                if (!init) {
                    // empty if block
                }
            }
            catch (RuntimeException init) {
                // empty catch block
            }
            StorableApi.addImportFormat((ImportFormat)this._xfaImportFormat);
            StorableApi.addExportFormat((ExportFormat)this._xfaExportFormat);
            StorableApi.addExportFormat((ExportFormat)this._jflapExportFormat);
        }
        AtomicReference<FAAutomatonModelEnum> previous = new AtomicReference<FAAutomatonModelEnum>(SimulationSettingsManager.getAutomatonModel());
        this._formalismListener = (compilerName, source, action) -> {
            if (SimulationSettingsManager.getAutomatonModel() != FAAutomatonModelEnum.NET) {
                previous.set(SimulationSettingsManager.getAutomatonModel());
            }
            boolean isFAAutomatonCompilerFormalism = compilerName.equals("FA Automaton Compiler");
            boolean isFANetCompilerFormalism = compilerName.equals("FA Net Compiler");
            if (!isFAAutomatonCompilerFormalism) {
                SimulationSettingsManager.setAutomatonModel((FAAutomatonModelEnum)FAAutomatonModelEnum.NET);
            } else {
                SimulationSettingsManager.setAutomatonModel((FAAutomatonModelEnum)((FAAutomatonModelEnum)previous.get()));
            }
            if ((isFAAutomatonCompilerFormalism || isFANetCompilerFormalism) && !this._loaded) {
                this.loadPalette();
            }
        };
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (fp != null) {
            FormalismPlugin.getCurrent().addFormalismChangeListener(this._formalismListener);
        }
        if (this.getProperties().getProperty(KEY_INIT).equals("true") && !this._loaded) {
            this.loadPalette();
        }
    }

    public boolean cleanup() {
        FormalismPlugin fp;
        ConfigurablePropertyManager propertyManager = ConfigurablePropertyManager.getInstance();
        propertyManager.removePropertyChangeListener(this._propertyChangeListener);
        propertyManager.removeConfigurableProperty(KEY_INIT);
        propertyManager.removeConfigurableProperty(KEY_MODE);
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin != null) {
            if (guiPlugin.getGui() != null) {
                Drawing drawing;
                Enumeration openDrawings = guiPlugin.getGui().drawings();
                while (openDrawings.hasMoreElements()) {
                    drawing = (Drawing)openDrawings.nextElement();
                    if (!(drawing instanceof FADrawing)) continue;
                    guiPlugin.getGui().closeDrawing(drawing);
                }
                openDrawings = guiPlugin.getGui().drawings();
                while (openDrawings.hasMoreElements()) {
                    drawing = (Drawing)openDrawings.nextElement();
                    if (!(drawing instanceof FADrawing)) continue;
                    return false;
                }
            }
            if (this._faFigureCreator != null) {
                guiPlugin.getFigureCreatorHolder().unregisterCreator((TextFigureCreator)this._faFigureCreator);
                this._faFigureCreator = null;
            }
        }
        this._settingsMenu.cleanup();
        this._compareGui.cleanup();
        if (drawPlugin != null) {
            MenuApi.unregisterMenu((JMenuItem)this._menu);
            StorableApi.removeImportFormat((ImportFormat)this._xfaImportFormat);
            StorableApi.removeExportFormat((ExportFormat)this._xfaExportFormat);
            StorableApi.removeExportFormat((ExportFormat)this._jflapExportFormat);
        }
        if (this._loaded) {
            this._pc.remove();
            this._loaded = false;
        }
        if ((fp = FormalismPlugin.getCurrent()) != null) {
            fp.removeFormalismChangeListener(this._formalismListener);
        }
        DrawingTypeManager.getInstance().unregister(FA_FILEFILTER);
        this._commandList.clear();
        CPNInstanceDrawing.unregisterInstanceDrawingFactory(FADrawing.class);
        return super.cleanup();
    }

    public void create() {
        if (this._loaded) {
            this._pc.remove();
            this._loaded = false;
        } else {
            this.loadPalette();
        }
    }

    private void loadPalette() {
        if (FADrawMode.getInstance().getMode() == 0) {
            this._pc = new PaletteCreator("FAPalette");
            LOGGER.debug((Object)"created standard palette");
        } else {
            this._pc = new AltPaletteCreator("FAPalette");
            LOGGER.debug((Object)"created alt palette");
        }
        this._loaded = true;
    }

    public void switchPalette() {
        if (this._loaded) {
            this._pc.remove();
            this.loadPalette();
        }
    }

    private CommandMenu createMenu() {
        this._menu = new CommandMenu("FA Drawing Tool");
        Command command = new ShowPaletteCommand((IPlugin)this);
        this._menu.add((AbstractCommand)command, 54);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        CommandMenu submenu = DrawApplication.createCommandMenu((String)"Decoration");
        command = new ChangeDecorationCommand("Start", new StartDecoration());
        submenu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        command = new ChangeDecorationCommand("End", new EndDecoration());
        submenu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        command = new ChangeDecorationCommand("Start/End", new StartEndDecoration());
        submenu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        command = new ChangeDecorationCommand("none", new NullDecoration());
        submenu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        this._menu.add((JMenuItem)submenu);
        command = new ChangeFADrawModeCommand();
        this._menu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        command = new ShowSettingsCommand(this._settingsMenu);
        this._menu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        command = new ShowComparatorCommand(this._compareGui);
        this._menu.add((AbstractCommand)command);
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        this._menu.addSeparator();
        command = CommandApi.createVersionInfoCommand((IPlugin)this);
        this._menu.add((AbstractCommand)command);
        this._menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.fa");
        this._commandList.put((AbstractCommand)command, (IPlugin)this);
        return this._menu;
    }

    public void deregisterPlugin(IPlugin plugin) {
        Enumeration<AbstractCommand> it = this._commandList.keys();
        while (it.hasMoreElements()) {
            AbstractCommand command = it.nextElement();
            if (!(this._commandList.get(command) instanceof FAPluginExtender)) continue;
            this._menu.remove(command);
            this._commandList.remove(command);
        }
        this._pluginList.remove(plugin);
    }

    public void registerPlugin(IPlugin plugin) {
        this._pluginList.add(plugin);
        if (plugin instanceof FAPluginExtender) {
            Vector<AbstractCommand> v = ((FAPluginExtender)plugin).getMenuCommands();
            for (AbstractCommand command : v) {
                this._menu.add(command);
                this._commandList.put(command, plugin);
                LOGGER.debug((Object)("Added command " + command.toString() + "\n of Plugin " + String.valueOf(plugin)));
            }
        }
    }

    public static FAPlugin getCurrent() {
        PluginManager pm = PluginManager.getInstance();
        if (pm == null) {
            return null;
        }
        return (FAPlugin)pm.getPluginByName("Renew Finite Automata Base");
    }

    public boolean getUseIndices() {
        return this.getProperties().getBoolProperty(KEY_USEINDICES);
    }

    private class FAFigureCreator
    implements TextFigureCreator {
        private FAFigureCreator() {
        }

        public boolean canCreateDefaultInscription(InscribableFigure figure) {
            if (figure instanceof FAStateFigure) {
                return true;
            }
            return figure instanceof FAArcConnection;
        }

        public boolean canCreateFigure(InscribableFigure figure) {
            return this.canCreateDefaultInscription(figure);
        }

        public TextFigure createTextFigure(InscribableFigure figure) {
            if (figure instanceof FAStateFigure) {
                return new FATextFigure(2);
            }
            if (figure instanceof FAArcConnection) {
                return new FATextFigure(1);
            }
            return null;
        }

        public String getDefaultInscription(InscribableFigure figure) {
            boolean useindices = FAPlugin.this.getProperties().getBoolProperty(FAPlugin.KEY_USEINDICES);
            String sp = FAPlugin.this.getProperties().getProperty(FAPlugin.KEY_STATE_PREFIX);
            String string = sp = sp == null ? "z" : sp;
            if (figure instanceof FAStateFigure) {
                CPNApplication da = GuiPlugin.getCurrent().getGui();
                int i = 0;
                if (da != null) {
                    HashSet<String> labels = new HashSet<String>();
                    Drawing d = da.drawing();
                    FigureEnumeration figEnum = d.figures();
                    while (figEnum.hasMoreElements()) {
                        FigureEnumeration stateChildren;
                        Figure fig = figEnum.nextFigure();
                        if (!(fig instanceof FAStateFigure) || !(stateChildren = ((FAStateFigure)fig).children()).hasMoreElements()) continue;
                        String label = ((TextFigure)stateChildren.nextFigure()).getText();
                        labels.add(label);
                    }
                    while (labels.contains(sp + i) || labels.contains(sp + "_" + i) || labels.contains(sp + "_{" + i + "}")) {
                        ++i;
                    }
                }
                if (useindices) {
                    return sp + "_{" + i + "}";
                }
                return sp + i;
            }
            return null;
        }
    }
}

