/*
 * Decompiled with CFR 0.152.
 */
package de.renew.appleui;

import de.renew.appleui.AboutDisplayer;
import de.renew.appleui.AppleUIListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;
import java.awt.Desktop;
import java.awt.Taskbar;
import java.awt.Toolkit;

public class AppleUI
extends PluginAdapter {
    private Desktop _desktop = null;
    private AppleUIListener _listener = null;
    private SoftDependency _guiDependency;

    public AppleUI(PluginProperties props) {
        super(props);
    }

    public void init() {
        Taskbar taskbar;
        this._desktop = Desktop.getDesktop();
        this._listener = new AppleUIListener();
        this.setAboutDisplayer(null);
        this._desktop.setAboutHandler(this._listener);
        this._desktop.addAppEventListener(this._listener);
        this._desktop.setQuitHandler(this._listener);
        this._desktop.setOpenFileHandler(this._listener);
        this._guiDependency = new SoftDependency((IPlugin)this, "de.renew.gui", "de.renew.appleui.GuiDependencyListener");
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
            taskbar.setIconImage(Toolkit.getDefaultToolkit().getImage(((Object)((Object)this)).getClass().getResource("/de/renew/appleui/images/Renew.png")));
        }
    }

    public boolean cleanup() {
        if (this._desktop != null) {
            this._desktop.removeAppEventListener(this._listener);
            this._desktop = null;
            this._listener = null;
        }
        if (this._guiDependency != null) {
            this._guiDependency.discard();
            this._guiDependency = null;
        }
        return true;
    }

    void setAboutDisplayer(AboutDisplayer displayer) {
        if (this._desktop != null && this._listener != null) {
            this._listener.setAboutDisplayer(displayer);
        }
    }
}

