/*
 * Decompiled with CFR 0.152.
 */
package de.renew.faformalism.util;

import de.renew.faformalism.util.FAAutomatonSimulationHelper;
import de.renew.faformalism.util.SimulationSettingsManager;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.unify.Tuple;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FASyntaxChecker {
    private static final Pattern NFA_ARC = Pattern.compile("^[0-9A-Za-z]?(,[0-9A-Za-z]?)*$");
    private static final Pattern PDA_ARC = Pattern.compile("^[0-9A-Za-z]?,[0-9A-Za-z$]?->[0-9A-Za-z$]?(\n([0-9A-Za-z]?,[0-9A-Za-z$]?->[0-9A-Za-z$]?))*$");

    private FASyntaxChecker() {
    }

    public static void checkArcSyntax(String arcInscription) throws SyntaxException {
        if (arcInscription == null) {
            arcInscription = "";
        }
        arcInscription = arcInscription.replace(" ", "");
        switch (SimulationSettingsManager.getAutomatonModel()) {
            case DFA: 
            case NFA: 
            case BUECHI: {
                Matcher m = NFA_ARC.matcher(arcInscription);
                if (m.matches()) {
                    return;
                }
                Pattern symbols = Pattern.compile("[0-9A-Za-z,]*");
                if (!symbols.matcher(arcInscription).matches()) {
                    throw new SyntaxException("Arc contains invalid characters! Allowed are digits, letters (english alphabet), ''(empty string), and ','.");
                }
                if (arcInscription.contains(",") || arcInscription.length() <= 1) break;
                throw new SyntaxException("Arcs may only read one letter at a time.");
            }
            case PDA: {
                Matcher m = PDA_ARC.matcher(arcInscription);
                if (m.matches()) {
                    return;
                }
                if (!arcInscription.contains("->")) {
                    throw new SyntaxException("Arc is missing instructions for updating the stack (->)!");
                }
                throw new SyntaxException("Arc inscription has invalid format. Allowed format is \"x,y->z\". For multiple inscriptions, separate them with a new line");
            }
        }
        throw new SyntaxException("Unknown automaton type set!");
    }

    public static void checkWordSyntax(String word) throws SyntaxException {
        if (word == null || !SimulationSettingsManager.getSimulateWordMode()) {
            return;
        }
        word = word.replace(" ", "");
        switch (SimulationSettingsManager.getAutomatonModel()) {
            case DFA: 
            case NFA: {
                FASyntaxChecker.checkNFAWordSyntax(word);
                return;
            }
            case BUECHI: {
                FASyntaxChecker.checkNFAWordSyntax(word.replace("\u00b0", "*"));
                if (!FAAutomatonSimulationHelper.canFire(new Tuple(new Object[]{word, null}, null), "")) {
                    throw new SyntaxException("One ore more words separated by a union operator do not end with '\u00b0'!");
                }
                return;
            }
            case PDA: {
                FASyntaxChecker.checkPDAWordSyntax(word);
                return;
            }
        }
        throw new SyntaxException("Unknown automaton type set!");
    }

    private static void checkPDAWordSyntax(String word) throws SyntaxException {
        if (!Pattern.compile("^[a-zA-Z0-9]*$").matcher(word).matches()) {
            throw new SyntaxException("Word contains letters that are not allowed. ");
        }
    }

    public static void checkNFAWordSyntax(String word) throws SyntaxException {
        if (word == null || word.isEmpty()) {
            return;
        }
        if (word.contains("\u00b0")) {
            throw new SyntaxException("Expression contains \u00b0, but automaton is interpreted as NFA. Change interpretation in 'FA Drawing Tool' -> 'FA Simulation Settings'!");
        }
        Pattern symbols = Pattern.compile("[0-9A-Za-z\\^+*()|]+");
        if (!symbols.matcher(word).matches()) {
            throw new SyntaxException("Word contains invalid characters! Allowed are digits, letters (english alphabet), '+', '*', '^', '(' and ')'.");
        }
        if (word.endsWith("^")) {
            throw new SyntaxException("Word can't end with '^'!");
        }
        if (word.charAt(0) == '*' || word.charAt(0) == '^') {
            throw new SyntaxException("Word starts with illegal character!");
        }
        if (word.contains("^|")) {
            throw new SyntaxException("Illegal use of operands: ^| at index " + word.indexOf("^|"));
        }
        word = word.replaceAll("\\^[*]", "*");
        word = word.replaceAll("[+]", "|");
        word = word.replaceAll("[\\^][|]", "+");
        for (int i = 0; i < word.length(); ++i) {
            if (word.charAt(i) != '^') continue;
            throw new SyntaxException("Misplaced character in word at index " + i + ": duplicate '^'");
        }
        try {
            Pattern.compile(word);
        }
        catch (PatternSyntaxException pse) {
            throw new SyntaxException(pse.getMessage());
        }
    }
}

