/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class DelayedField
implements Serializable {
    private static final long serialVersionUID = -6231461074991131516L;
    private final Object _field;
    private final DelayedFieldOwner _owner;

    DelayedField(Object field, DelayedFieldOwner owner) {
        this._field = field;
        this._owner = owner;
    }

    void reassign() throws IOException {
        this._owner.reassignField(this._field);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rout = null;
        if (out instanceof RenewObjectOutputStream) {
            rout = (RenewObjectOutputStream)out;
        }
        if (rout != null) {
            rout.beginDomain(this._owner);
        }
        out.defaultWriteObject();
        if (rout != null) {
            rout.endDomain(this._owner);
        }
    }

    public String toString() {
        return "DelayedField(_owner:" + String.valueOf(this._owner) + ", value:" + String.valueOf(this._field) + ")";
    }
}

