/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulatorontology.simulation;

public class StepIdentifier
implements Comparable<StepIdentifier> {
    private final long _simulationRunId;
    private final long[] _stepCounts;

    public StepIdentifier(long simulationRunId, long[] stepCounts) {
        this._simulationRunId = simulationRunId;
        this._stepCounts = stepCounts;
    }

    public long[] getComponents() {
        return this._stepCounts;
    }

    public long getSimulationRunId() {
        return this._simulationRunId;
    }

    public int hashCode() {
        if (this._stepCounts.length != 0) {
            return (int)this._stepCounts[0];
        }
        return 0;
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof StepIdentifier) {
            StepIdentifier other = (StepIdentifier)otherObj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this._stepCounts.length != 0) {
            builder.append(this._stepCounts[0]);
        }
        for (int x = 1; x < this._stepCounts.length; ++x) {
            builder.append(",");
            builder.append(this._stepCounts[x]);
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int compareTo(StepIdentifier other) throws ClassCastException {
        long[] otherComp = other.getComponents();
        if (this._simulationRunId < other._simulationRunId) {
            return -1;
        }
        if (this._simulationRunId > other._simulationRunId) {
            return 1;
        }
        for (int x = 0; x < otherComp.length; ++x) {
            if (this._stepCounts[x] < otherComp[x]) {
                return -1;
            }
            if (this._stepCounts[x] <= otherComp[x]) continue;
            return 1;
        }
        return 0;
    }
}

