/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulatorontology.shadow;

import de.renew.simulatorontology.serialisation.SerialisationListener;
import de.renew.simulatorontology.serialisation.SerialisationListenerRegistry;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShadowNetSystem
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ShadowNetSystem.class);
    private static final long serialVersionUID = 4619730346099695519L;
    private final Set<ShadowNet> _nets = new HashSet<ShadowNet>();
    private transient Set<ShadowNet> _compiledNets = new HashSet<ShadowNet>();
    private transient Set<ShadowNet> _uncompiledNets = new HashSet<ShadowNet>();
    private transient ShadowNetLoader _netLoader = null;

    public ShadowNetSystem() {
    }

    public ShadowNetSystem(ShadowNetLoader netLoader) {
        this.setNetLoader(netLoader);
    }

    public void recompile() {
        this._uncompiledNets.addAll(this._compiledNets);
        this._compiledNets.clear();
    }

    public void setNetLoader(ShadowNetLoader netLoader) {
        this._netLoader = netLoader;
    }

    public ShadowNetLoader getNetLoader() {
        return this._netLoader;
    }

    public void add(ShadowNet net) {
        this._nets.add(net);
        if (!this._compiledNets.contains(net)) {
            this._uncompiledNets.add(net);
        }
    }

    protected void remove(ShadowNet net) {
        this._nets.remove(net);
        this._compiledNets.remove(net);
        this._uncompiledNets.remove(net);
    }

    public void markAsCompiled(ShadowNet net) {
        if (this._nets.contains(net)) {
            this._compiledNets.add(net);
            this._uncompiledNets.remove(net);
        }
    }

    public Set<ShadowNet> elements() {
        return Collections.unmodifiableSet(this._nets);
    }

    public Set<ShadowNet> getUncompiledNets() {
        return new HashSet<ShadowNet>(this._uncompiledNets);
    }

    public boolean hasUncompiledNets() {
        return !this._uncompiledNets.isEmpty();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Optional<SerialisationListener<ShadowNetSystem>> listener = SerialisationListenerRegistry.getListener(ShadowNetSystem.class);
        if (listener.isPresent()) {
            listener.get().onWrite(this, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._uncompiledNets = new HashSet<ShadowNet>(this._nets);
        this._compiledNets = new HashSet<ShadowNet>();
        Optional<SerialisationListener<ShadowNetSystem>> listener = SerialisationListenerRegistry.getListener(ShadowNetSystem.class);
        if (listener.isPresent()) {
            listener.get().onRead(this, in);
        }
    }
}

