/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulatorontology.shadow;

import de.renew.simulatorontology.shadow.ShadowInscribable;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNode;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class ShadowConnection
extends ShadowInscribable {
    private boolean _trace;
    private final ShadowNode _from;
    private final ShadowNode _to;

    protected ShadowConnection(ShadowNode from, ShadowNode to) {
        super(ShadowConnection.ensureIdentity(from, to));
        this._from = from;
        this._to = to;
        from.add(this);
        to.add(this);
    }

    private static ShadowNet ensureIdentity(ShadowNode from, ShadowNode to) {
        if (from == null | to == null) {
            throw new RuntimeException("Connection must be connected at both ends.");
        }
        ShadowNet net = from.getNet();
        if (net != to.getNet()) {
            throw new RuntimeException("Must connect within one net.");
        }
        return net;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public void setTrace(boolean trace) {
        if (this._trace != trace) {
            this._trace = trace;
        }
    }

    @Override
    public void discard() {
        this._from.remove(this);
        this._to.remove(this);
        super.discard();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._from.add(this);
        this._to.add(this);
    }
}

