/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceOperationIcon;
import bibliothek.extension.gui.dock.preference.PreferenceOperationText;
import bibliothek.extension.gui.dock.preference.PreferenceOperationView;
import bibliothek.extension.gui.dock.preference.PreferenceOperationViewListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class PreferenceOperation {
    public static final PreferenceOperation DELETE = new PreferenceOperation("delete");
    public static final PreferenceOperation DEFAULT = new PreferenceOperation("default");
    private String key;
    private Icon icon;
    private String iconId = "null";
    private String description;
    private String descriptionId = "null";
    private List<View> views = new ArrayList<View>();

    public PreferenceOperation(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.key = key;
    }

    public PreferenceOperation(String key, Icon icon, String description) {
        this(key);
        this.setIcon(icon);
        this.setDescription(description);
    }

    public PreferenceOperationView create(PreferenceModel model) {
        return new View(model);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            return this.key.equals(((PreferenceOperation)obj).key);
        }
        return false;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        for (View view : this.views) {
            view.icon.setValue(icon);
        }
    }

    public String getIconId() {
        return this.iconId;
    }

    public void setIconId(String iconId) {
        if (iconId == null) {
            throw new IllegalArgumentException("iconId must not be null");
        }
        this.iconId = iconId;
        for (View view : this.views) {
            view.icon.setId(iconId);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescriptionId(String descriptionId) {
        if (descriptionId == null) {
            throw new IllegalArgumentException("descriptionId must not be null");
        }
        this.descriptionId = descriptionId;
        for (View view : this.views) {
            view.description.setId(descriptionId);
        }
    }

    public void setDescription(String description) {
        this.description = description;
        for (View view : this.views) {
            view.description.setValue(description);
        }
    }

    static {
        DELETE.setIconId("delete.small");
        DELETE.setDescriptionId("preference.operation.delete");
        DEFAULT.setIconId("default.small");
        DEFAULT.setDescriptionId("preference.operation.default");
    }

    private class View
    implements PreferenceOperationView {
        private List<PreferenceOperationViewListener> listeners = new ArrayList<PreferenceOperationViewListener>();
        private PreferenceOperationIcon icon;
        private PreferenceOperationText description;

        public View(PreferenceModel model) {
            PreferenceOperation.this.views.add(this);
            this.icon = new PreferenceOperationIcon(PreferenceOperation.this.iconId, this.getOperation()){

                protected void changed(Icon oldValue, Icon newValue) {
                    View.this.fireIconChanged(oldValue, newValue);
                }
            };
            this.icon.setValue(PreferenceOperation.this.icon);
            this.icon.setManager(model.getController().getIcons());
            this.description = new PreferenceOperationText(PreferenceOperation.this.descriptionId, this.getOperation()){

                protected void changed(String oldValue, String newValue) {
                    View.this.fireDescriptionChanged(oldValue, newValue);
                }
            };
            this.description.setValue(PreferenceOperation.this.description);
            this.description.setController(model.getController());
        }

        public void destroy() {
            PreferenceOperation.this.views.remove(this);
            this.icon.setManager(null);
            this.description.setController(null);
        }

        public String getDescription() {
            return (String)this.description.value();
        }

        public Icon getIcon() {
            return (Icon)this.icon.value();
        }

        public PreferenceOperation getOperation() {
            return PreferenceOperation.this;
        }

        private void fireIconChanged(Icon oldIcon, Icon newIcon) {
            for (PreferenceOperationViewListener listener : this.listeners) {
                listener.iconChanged(this, oldIcon, newIcon);
            }
        }

        private void fireDescriptionChanged(String oldDescription, String newDescription) {
            for (PreferenceOperationViewListener listener : this.listeners) {
                listener.descriptionChanged(this, oldDescription, newDescription);
            }
        }

        public void addListener(PreferenceOperationViewListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(PreferenceOperationViewListener listener) {
            this.listeners.remove(listener);
        }
    }
}

