/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class HalfMoonFigure
extends AttributeFigure {
    static final long serialVersionUID = -6856203289355118951L;
    private Rectangle _fDisplayBox;

    public HalfMoonFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public HalfMoonFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this._fDisplayBox = new Rectangle(origin);
        this._fDisplayBox.add(corner);
    }

    protected void basicMoveBy(int x, int y) {
        this._fDisplayBox.translate(x, y);
    }

    public Insets connectionInsets() {
        Rectangle r = this._fDisplayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopEllipseConnector((Figure)this);
    }

    public boolean containsPoint(int x, int y) {
        if (super.containsPoint(x, y)) {
            return Geom.ellipseContainsPoint((Rectangle)this.displayBox(), (int)x, (int)y);
        }
        return false;
    }

    public Rectangle displayBox() {
        return new Rectangle(this._fDisplayBox.x, this._fDisplayBox.y, this._fDisplayBox.width, this._fDisplayBox.height);
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillArc(r.x, r.y, r.width - 1, r.height - 1, 120, 120);
        g.setColor(Color.white);
        g.fillRect(this.getXabs() + this.displayBox().width / 4, this.getYabs(), Double.valueOf(this.displayBox().width / 2).intValue(), Double.valueOf(this.getYprime() * 2.0).intValue());
    }

    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        g.drawArc(r.x, r.y, r.width - 1, r.height - 1, 120, 120);
        g.drawLine(this.getXabs() + this.displayBox().width / 4, this.getYabs(), this.getXabs() + this.displayBox().width / 4, Double.valueOf(this.getYprime() * 2.0).intValue());
    }

    private int getXabs() {
        return this.displayBox().x;
    }

    private int getYabs() {
        float b = this.displayBox().height / 2;
        return Double.valueOf((double)((float)this.displayBox().y + b) - this.getYprime()).intValue();
    }

    private double getYprime() {
        float b = this.displayBox().height / 2;
        return Math.sqrt(0.75 * (double)b * (double)b);
    }

    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        BoxHandleKit.addHandles((Figure)this, handles);
        return handles;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._fDisplayBox.x);
        dw.writeInt(this._fDisplayBox.y);
        dw.writeInt(this._fDisplayBox.width);
        dw.writeInt(this._fDisplayBox.height);
    }
}

