/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeEvent;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.fa.figures.FAArcConnection;
import de.renew.gui.CPNSimulation;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FAArcInstanceConnection
extends AbstractFigure
implements InstanceFigure,
EventListener {
    public static final Logger LOGGER = Logger.getLogger(FAArcInstanceConnection.class);
    private FAArcConnection _faArcConnection;
    private InstanceDrawing _drawing;
    private TransitionInstanceAccessor _transitionInstance;
    private boolean _afterglow = false;
    private Thread _afterglowThread;
    private AWTSynchronizedUpdate _updateTask;
    private RemoteEventForwarder _forwarder;

    public FAArcInstanceConnection(InstanceDrawing drawing, FAArcConnection fac, Hashtable<Serializable, ObjectAccessor> netElements) {
        this._faArcConnection = fac;
        this._drawing = drawing;
        this.initialize(netElements);
        this._updateTask = new AWTSynchronizedUpdate(new Runnable(){

            @Override
            public void run() {
                FAArcInstanceConnection.this.executeUpdate();
            }
        });
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> netElements) {
        if (netElements.size() != 1) {
            LOGGER.error((Object)("Error: There are not excactly three net elements for the figure " + String.valueOf((Object)this)));
            return;
        }
        Enumeration<ObjectAccessor> faArcNetElements = netElements.elements();
        while (faArcNetElements.hasMoreElements()) {
            ObjectAccessor netElementAccessor = faArcNetElements.nextElement();
            if (!(netElementAccessor instanceof TransitionInstanceAccessor)) continue;
            this._transitionInstance = (TransitionInstanceAccessor)netElementAccessor;
        }
        try {
            this._forwarder = new RemoteEventForwarder((EventListener)this);
            this._transitionInstance.addRemoteEventListener((RemoteEventListener)this._forwarder);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isChangingState() {
        try {
            return this._transitionInstance.isFiring();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void draw(Graphics g) {
    }

    public Rectangle displayBox() {
        return this._faArcConnection.displayBox();
    }

    public boolean containsPoint(int x, int y) {
        return this._faArcConnection.containsPoint(x, y);
    }

    public void basicDisplayBox(Point origin, Point corner) {
    }

    protected void basicMoveBy(int dx, int dy) {
    }

    public boolean isHighlighted() {
        return this.isChangingState() || this._afterglow;
    }

    private void invalidateHighlight() {
        Figure highlight = this._faArcConnection.getHighlightFigure();
        if (highlight != null) {
            Rectangle area = highlight.displayBox();
            CH.ifa.draw.framework.DrawingChangeEvent dce = new CH.ifa.draw.framework.DrawingChangeEvent((Drawing)this._drawing, area);
            this._drawing.drawingInvalidated((DrawingChangeEvent)dce);
        }
    }

    public Vector<FigureHandle> handles() {
        Vector<FigureHandle> handles = new Vector<FigureHandle>();
        handles.addElement((FigureHandle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        handles.addElement((FigureHandle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.addElement((FigureHandle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.addElement((FigureHandle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return handles;
    }

    private void executeUpdate() {
        LOGGER.debug((Object)"executeUpdate() called");
        if (this.listener() != null) {
            this._afterglow = true;
            this.invalidate();
            this.invalidateHighlight();
            this.listener().figureRequestUpdate(StorableApi.createFigureChangeEvent((Figure)this));
            final FAArcInstanceConnection thizz = this;
            this._afterglowThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(300L);
                        }
                        FAArcInstanceConnection.this._afterglow = false;
                        FAArcInstanceConnection.this.invalidate();
                        FAArcInstanceConnection.this.invalidateHighlight();
                        FAArcInstanceConnection.this.listener().figureRequestUpdate(StorableApi.createFigureChangeEvent((Figure)thizz));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            SimulationThreadPool.getCurrent().execute((Runnable)this._afterglowThread);
        }
    }

    public void update() {
        if (this._updateTask != null) {
            this._updateTask.scheduleUpdate();
        }
    }

    public boolean inspect(DrawingView view, boolean alternate) {
        if (alternate) {
            if (this.fire()) {
                String name;
                try {
                    name = this._transitionInstance.asString();
                }
                catch (RemoteException e) {
                    name = e.toString();
                }
                view.editor().showStatus("Transition " + name + " fired.");
            } else {
                view.editor().showStatus("No binding for this transition.");
            }
        }
        return true;
    }

    public boolean fire() {
        boolean result;
        CPNSimulation simulation = this.getSimulation();
        simulation.getBreakpointManager().clearLog();
        try {
            result = this._transitionInstance.fireOneBinding();
        }
        catch (RemoteException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            result = false;
        }
        simulation.simulationRefresh();
        return result;
    }

    protected CPNSimulation getSimulation() {
        return ModeReplacement.getInstance().getSimulation();
    }
}

