/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.util.Palette;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.fa.figures.EndDecoration;
import de.renew.fa.figures.FAArcConnection;
import de.renew.fa.figures.FAFigureCreationTool;
import de.renew.fa.figures.FALoopArcConnectionCreationTool;
import de.renew.fa.figures.FATextFigure;
import de.renew.fa.figures.FATextFigureCreationTool;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.fa.figures.StartDecoration;
import de.renew.fa.figures.StartEndDecoration;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import org.apache.log4j.Logger;

public class PaletteCreator {
    public static final Logger LOGGER = Logger.getLogger(PaletteCreator.class);
    private String _label;
    Palette _palette;

    public PaletteCreator(String name) {
        this.createPalette(name);
    }

    protected void createPalette(String paletteName) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error((Object)"No GuiPlugin available");
            return;
        }
        String images = "/de/renew/fa/images/";
        PaletteHolder paletteHolder = starter.getPaletteHolder();
        this._palette = new Palette(paletteName);
        DrawingEditor editor = starter.getDrawingEditor();
        Object tool = new FAFigureCreationTool(editor, new StartDecoration());
        this._palette.add(paletteHolder.createToolButton(images + "fa_state_s", "FA Start State Tool", (Tool)tool));
        tool = new FAFigureCreationTool(editor);
        this._palette.add(paletteHolder.createToolButton(images + "fa_state", "FA State Tool", (Tool)tool));
        tool = new FAFigureCreationTool(editor, new EndDecoration());
        this._palette.add(paletteHolder.createToolButton(images + "fa_state_e", "FA End State Tool", (Tool)tool));
        tool = new FAFigureCreationTool(editor, new StartEndDecoration());
        this._palette.add(paletteHolder.createToolButton(images + "fa_state_se", "FA Start End State Tool", (Tool)tool));
        FATextFigure prototype = FATextFigure.NAME;
        prototype.setAlignment(1);
        tool = new ConnectedTextTool(editor, (TextFigure)prototype);
        this._palette.add(paletteHolder.createToolButton("/de/renew/gui/images/NAME", "FA Name Tool", (Tool)tool));
        prototype = FATextFigure.INSCRIPTION;
        prototype.setAlignment(1);
        tool = new FATextFigureCreationTool(editor, (TextFigure)prototype, 1);
        this._palette.add(paletteHolder.createToolButton("/de/renew/gui/images/INSCR", "FA Inscription Tool", (Tool)tool));
        FAWordTextFigure word = new FAWordTextFigure();
        word.setAlignment(1);
        tool = new FATextFigureCreationTool(editor, word, 0);
        this._palette.add(paletteHolder.createToolButton("de/renew/fa/images/fa_word", "FA Word Placement Tool", (Tool)tool));
        FAArcConnection arc = new FAArcConnection(null, (LineDecoration)new ArrowTip(), "");
        Integer spline = 1;
        arc.setAttribute("LineShape", spline);
        tool = new ConnectionTool(editor, (ConnectionFigure)arc);
        this._palette.add(paletteHolder.createToolButton("/de/renew/gui/images/ARC", "FA ArcConnection Tool", (Tool)tool));
        tool = new FALoopArcConnectionCreationTool(editor);
        this._palette.add(paletteHolder.createToolButton(images + "fa_loop", "FA Loop ArcConnection Tool", (Tool)tool));
        paletteHolder.addPalette(this._palette);
    }

    public String getLabel() {
        return this._label;
    }

    public void remove() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            return;
        }
        starter.getPaletteHolder().removePalette(this._palette);
    }

    public String toString() {
        return this.getLabel();
    }
}

