/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.models.TreeElement;
import de.renew.navigator.vc.Repository;
import java.awt.Color;
import java.awt.Font;
import java.util.Set;
import javax.swing.tree.DefaultTreeCellRenderer;

class RepositoryTreeCellRenderer
extends FileTreeCellRenderer {
    public static final Color MODIFIED_COLOR = new Color(0, 51, 153);
    public static final Color ADDED_COLOR = new Color(0, 102, 0);
    private static final int RGB_SHARE = 150;
    private final Set<Repository> _repositories;

    RepositoryTreeCellRenderer(Set<Repository> repositories) {
        this._repositories = repositories;
    }

    public void render(DefaultTreeCellRenderer target, TreeElement element, boolean selected, boolean expanded) {
        for (Repository repository : this._repositories) {
            if (repository.getRootDirectory().equals(element.getFile())) {
                target.setText(element.getFile().getName() + " @ " + repository.getBranch());
            }
            if (repository.getIgnored().contains(element.getFile())) {
                target.setForeground(new Color(150, 150, 150));
                target.setText(target.getText());
                return;
            }
            boolean isModified = repository.getModified().contains(element.getFile());
            boolean isAdded = repository.getAdded().contains(element.getFile());
            if (isModified || isAdded) {
                target.setFont(new Font(target.getFont().getName(), 1, target.getFont().getSize()));
                target.setText(target.getText() + " - ");
            }
            if (isModified) {
                target.setText(target.getText() + "M");
                target.setForeground(MODIFIED_COLOR);
            }
            if (!isAdded) continue;
            target.setText(target.getText() + "A");
            target.setForeground(ADDED_COLOR);
        }
    }
}

