/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.unify.Impossible;
import de.renew.util.Value;

public final class BasicUnaryFunction
implements Function {
    private static final int ID_LNOT = 1;
    private static final int ID_NOT = 2;
    private static final int ID_NEG = 3;
    private static final int ID_POS = 4;
    public static final BasicUnaryFunction LNOT = new BasicUnaryFunction(1);
    public static final BasicUnaryFunction NOT = new BasicUnaryFunction(2);
    public static final BasicUnaryFunction NEG = new BasicUnaryFunction(3);
    public static final BasicUnaryFunction POS = new BasicUnaryFunction(4);
    private final int _funcNum;

    private BasicUnaryFunction(int funcNum) {
        this._funcNum = funcNum;
    }

    public Object function(Object param) throws Impossible {
        if (!(param instanceof Value)) {
            throw new Impossible();
        }
        Object obj = ((Value)param).value;
        if (obj instanceof Integer || obj instanceof Character || obj instanceof Short || obj instanceof Byte) {
            int arg = obj instanceof Character ? ((Character)obj).charValue() : ((Number)obj).intValue();
            int result = switch (this._funcNum) {
                case 2 -> ~arg;
                case 3 -> -arg;
                case 4 -> arg;
                default -> throw new Impossible();
            };
            return new Value((Object)result);
        }
        if (obj instanceof Long) {
            long arg = (Long)obj;
            long result = switch (this._funcNum) {
                case 2 -> arg ^ 0xFFFFFFFFFFFFFFFFL;
                case 3 -> -arg;
                case 4 -> arg;
                default -> throw new Impossible();
            };
            return new Value((Object)result);
        }
        if (obj instanceof Float) {
            float arg = ((Float)obj).floatValue();
            float result = switch (this._funcNum) {
                case 3 -> -arg;
                case 4 -> arg;
                default -> throw new Impossible();
            };
            return new Value((Object)Float.valueOf(result));
        }
        if (obj instanceof Double) {
            double arg = (Double)obj;
            double result = switch (this._funcNum) {
                case 3 -> -arg;
                case 4 -> arg;
                default -> throw new Impossible();
            };
            return new Value((Object)result);
        }
        if (obj instanceof Boolean) {
            boolean arg = (Boolean)obj;
            if (this._funcNum == 1) {
                return new Value((Object)(!arg ? 1 : 0));
            }
            throw new Impossible();
        }
        throw new Impossible();
    }
}

