/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.PluginManager;
import de.renew.plugin.SoftDependencyListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SoftDependency
implements IPluginManagerListener {
    public static final Logger LOGGER = Logger.getLogger(SoftDependency.class);
    private String _pluginService;
    private IPlugin _provider;
    private String _listenerClass;
    private SoftDependencyListener _listener;
    private IPlugin _caller;
    private PluginManager _mgr;

    public SoftDependency(IPlugin caller, String pluginService, String listenerClass) {
        this._caller = caller;
        this._pluginService = pluginService;
        this._listenerClass = listenerClass;
        this._listener = null;
        this._provider = null;
        this._mgr = PluginManager.getInstance();
        LOGGER.debug((Object)("Soft dependency from " + String.valueOf(caller) + " to " + pluginService + " registered, using " + listenerClass + "."));
        this._mgr.addPluginManagerListener(this);
        this.checkServiceAvailable();
    }

    public synchronized void discard() {
        LOGGER.debug((Object)("Unregistering soft dependency from " + String.valueOf(this._caller) + " to " + this._pluginService + "."));
        this._mgr.removePluginManagerListener(this);
        this.fireServiceRemoved();
        this._listener = null;
    }

    public SoftDependencyListener getListener() {
        if (this._listener == null) {
            try {
                Class<?> clazz = Class.forName(this._listenerClass, true, this._mgr.getBottomClassLoader());
                try {
                    Constructor<?> constructor = clazz.getConstructor(IPlugin.class);
                    this._listener = (SoftDependencyListener)constructor.newInstance(this._caller);
                }
                catch (NoSuchMethodException e) {
                    this._listener = (SoftDependencyListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    LOGGER.debug((Object)("WARNING: Soft dependency from " + String.valueOf(this._caller) + " to " + this._pluginService + ": listener is created with no-arg constructor of " + String.valueOf(clazz) + "."));
                }
                LOGGER.debug((Object)("Soft dependency from " + String.valueOf(this._caller) + " to " + this._pluginService + ": created " + String.valueOf(this._listener) + "."));
            }
            catch (InvocationTargetException e) {
                LOGGER.warn((Object)("WARNING: Soft dependency from " + String.valueOf(this._caller) + " to " + this._pluginService + " could not be created: " + String.valueOf(e.getTargetException()) + "."));
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("WARNING: Soft dependency from " + String.valueOf(this._caller) + " to " + this._pluginService + " could not be created: " + String.valueOf(e) + "."));
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
            catch (ExceptionInInitializerError e) {
                LOGGER.warn((Object)("WARNING: Soft dependency from " + String.valueOf(this._caller) + " to " + this._pluginService + " could not be created: " + String.valueOf(e.getException()) + "."));
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this._listener;
    }

    private void checkServiceAvailable() {
        Collection<IPlugin> providers = this._mgr.getPluginsProviding(this._pluginService);
        if (!providers.isEmpty()) {
            this.fireServiceAvailable(providers.iterator().next());
        } else {
            this.fireServiceRemoved();
        }
    }

    private void fireServiceAvailable(IPlugin provider) {
        if (this._provider == null && this.getListener() != null) {
            LOGGER.debug((Object)("Soft dependency from " + String.valueOf(this._caller) + " to " + String.valueOf(provider) + " activated."));
            this._listener.serviceAvailable(provider);
            this._provider = provider;
        }
    }

    private void fireServiceRemoved() {
        if (this._provider != null && this._listener != null) {
            LOGGER.debug((Object)("Soft dependency from " + String.valueOf(this._caller) + " to " + String.valueOf(this._provider) + " deactivated."));
            this.getListener().serviceRemoved(this._provider);
            this._provider = null;
        }
    }

    @Override
    public synchronized void serviceAdded(String service, IPlugin provider) {
        if (service.equals(this._pluginService)) {
            Collection<IPlugin> providers = this._mgr.getPluginsProviding(this._pluginService);
            assert (!providers.isEmpty()) : "PluginManager misinformed soft dependency from " + String.valueOf(this._caller) + " to " + service;
            this.fireServiceAvailable(providers.iterator().next());
        }
    }

    @Override
    public synchronized void serviceRemoved(String service, IPlugin provider) {
        if (service.equals(this._pluginService)) {
            this.fireServiceRemoved();
        }
    }
}

