/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.PluginManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PropertyHelper {
    public static final Logger LOGGER = Logger.getLogger(PropertyHelper.class);

    public static int getIntProperty(Properties p, String property) {
        return PropertyHelper.getIntProperty(p, property, -1);
    }

    public static int getIntProperty(Properties p, String property, int defaultValue) {
        String str = p.getProperty(property, Integer.toString(defaultValue));
        int result = defaultValue;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)("Invalid value for int property: " + property + "=" + str + "(using default: " + defaultValue + ")."));
        }
        return result;
    }

    public static boolean getBoolProperty(Properties props, String property, boolean def) {
        String value = props.getProperty(property);
        if (value == null) {
            return def;
        }
        if (value.trim().equals("")) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    public static boolean getBoolProperty(Properties props, String property) {
        return PropertyHelper.getBoolProperty(props, property, false);
    }

    public static KeyStroke getHotkeyProperty(Properties props, String propertyName, KeyStroke fallback) {
        String value = props.getProperty(propertyName);
        if (fallback == null) {
            fallback = KeyStroke.getKeyStroke(65535, 0);
        }
        if (value == null) {
            return fallback;
        }
        String[] comps = value.split("[+]");
        String key = comps[comps.length - 1].trim();
        int keyCode = KeyEvent.getExtendedKeyCodeForChar(key.charAt(0));
        if (key.length() > 1) {
            if (key.toLowerCase().equals("delete")) {
                keyCode = 127;
            } else {
                LOGGER.error((Object)("The keybinding property " + propertyName + " contains no valid key."));
                return fallback;
            }
        }
        int modifiers = 0;
        block16: for (int i = 0; i < comps.length - 1; ++i) {
            String s;
            switch (s = comps[i]) {
                case "shift": {
                    modifiers |= 0x40;
                    continue block16;
                }
                case "ctrl": {
                    modifiers |= 0x80;
                    continue block16;
                }
                case "meta": {
                    modifiers |= 0x100;
                    continue block16;
                }
                case "alt": {
                    modifiers |= 0x200;
                    continue block16;
                }
                case "alt graph": {
                    modifiers |= 0x2000;
                    continue block16;
                }
                case "primary key": {
                    modifiers |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
                    continue block16;
                }
                default: {
                    LOGGER.error((Object)("The keybinding property " + propertyName + " contains an unknown modifier " + s + "."));
                    return fallback;
                }
            }
        }
        return KeyStroke.getKeyStroke(keyCode, modifiers);
    }

    public static Collection<String> parseListString(String list, StringTokenizer tok, boolean trim) {
        Vector<String> result = new Vector<String>(tok.countTokens());
        try {
            while (tok.hasMoreTokens()) {
                String currentToken = tok.nextToken();
                if (trim) {
                    currentToken = currentToken.trim();
                }
                result.add(currentToken);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.error((Object)("PluginLoader: " + String.valueOf(e) + " when parsing " + list + " as list!"));
        }
        return result;
    }

    public static Collection<String> parseListString(String list) {
        return PropertyHelper.parseListString(list, new StringTokenizer(list, ","), true);
    }

    public static Collection<String> parsePathListString(String list) {
        return PropertyHelper.parseListString(list, new StringTokenizer(list, File.pathSeparator), false);
    }

    public static List<String> getListProperty(Properties props, String propName) {
        boolean goon = true;
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (goon) {
            String currentProp = props.getProperty(propName + "_" + i);
            if (currentProp == null) {
                goon = false;
                break;
            }
            result.add(currentProp);
            ++i;
        }
        return result;
    }

    public static Class<?> getClassProperty(Properties props, String propName, Class<?> typeRequest, Class<?> def) {
        Class<?> result = null;
        String className = props.getProperty(propName);
        if (className != null) {
            try {
                result = Class.forName(className, true, PluginManager.getInstance().getBottomClassLoader());
                if (!typeRequest.isAssignableFrom(result)) {
                    LOGGER.error((Object)("Property " + propName + " is invalid, ignoring: " + result.getName() + " is not a subtype of " + typeRequest.getName() + "."));
                    result = null;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("Property " + propName + " is invalid, ignoring: Class " + className + " not found."));
                result = null;
            }
        }
        if (result == null) {
            result = def;
        }
        return result;
    }

    public static Class<?> getClassProperty(Properties props, String propName, Class<?> typeRequest) {
        return PropertyHelper.getClassProperty(props, propName, typeRequest, null);
    }
}

