/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.ClassLoaderManager;
import de.renew.plugin.CollectionLister;
import de.renew.plugin.CommandsListener;
import de.renew.plugin.CommandsProvider;
import de.renew.plugin.DefaultClassLoaderManager;
import de.renew.plugin.DefaultLogStrategy;
import de.renew.plugin.DependencyCheckList;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.IPluginManagerListener;
import de.renew.plugin.Loader;
import de.renew.plugin.LogStrategy;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.ServiceLookupInfrastructure;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.command.ExitCommand;
import de.renew.plugin.command.GCCommand;
import de.renew.plugin.command.GetPropertyCommand;
import de.renew.plugin.command.InfoCommand;
import de.renew.plugin.command.ListCommand;
import de.renew.plugin.command.LoadCommand;
import de.renew.plugin.command.NoOpCommand;
import de.renew.plugin.command.ScriptCommand;
import de.renew.plugin.command.SetPropertyCommand;
import de.renew.plugin.command.SleepCommand;
import de.renew.plugin.command.UnloadCommand;
import de.renew.plugin.di.Container;
import de.renew.plugin.di.MissingDependencyException;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.jpms.impl.ModuleManager;
import de.renew.plugin.load.DIPluginLoader;
import de.renew.plugin.load.PluginLoaderComposition;
import de.renew.plugin.load.SimplePluginLoader;
import de.renew.plugin.locate.PluginJarLocationFinder;
import de.renew.plugin.locate.PluginLocationFinders;
import de.renew.plugin.locate.PluginSubDirFinder;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;

public class PluginManager
implements Serializable,
CommandsProvider {
    public static final String COMMAND_SEPERATOR = "---";
    public static final Logger LOGGER = Logger.getLogger(PluginManager.class);
    private final ModuleManager _moduleManager = new ModuleManager();
    public static final int CLEANUP_TIMEOUT = 20000;
    public static final String PLUGIN_LOCATIONS_PROPERTY = "pluginLocations";
    protected static PluginManager _instance;
    DependencyCheckList<IPlugin> _dependencyList = new DependencyCheckList();
    private final List<IPlugin> _modularPlugins = new ArrayList<IPlugin>();
    private Map<String, CLCommand> _commands = Collections.synchronizedMap(new TreeMap());
    private Set<IPluginManagerListener> _managerListener;
    private Set<IPlugin> _blockers = Collections.synchronizedSet(new HashSet());
    private boolean _terminating = false;
    protected PluginLocationFinders _locationFinder = PluginLocationFinders.getInstance();
    private PluginLoaderComposition _loader;
    private final ClassLoaderManager _classLoaderManager;
    protected static URL _loaderLocation;
    private LogStrategy _logStrategy;
    private static final String PREF_DIR = ".renew";
    private ArrayList<CommandsListener> _commandsListener = new ArrayList();
    private final ServiceContainer _container;

    public static URL getLoaderLocation() {
        if (_loaderLocation == null) {
            _loaderLocation = PluginManager.getDefaultLoaderLocation();
        }
        return _loaderLocation;
    }

    private static URL getDefaultLoaderLocation() {
        URL url = Loader.class.getProtectionDomain().getCodeSource().getLocation();
        String base = url.toExternalForm();
        base = base.substring(0, base.lastIndexOf("/"));
        try {
            return new URL(base + "/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static LogStrategy getDefaultLogStrategy() {
        return new DefaultLogStrategy();
    }

    private static ClassLoaderManager getDefaultClassLoaderManager() {
        return new DefaultClassLoaderManager();
    }

    protected PluginManager(URL url, LogStrategy logStrategy, ClassLoaderManager classLoaderManager) {
        if (logStrategy == null) {
            logStrategy = PluginManager.getDefaultLogStrategy();
        }
        this._logStrategy = logStrategy;
        if (classLoaderManager == null) {
            classLoaderManager = PluginManager.getDefaultClassLoaderManager();
        }
        this._classLoaderManager = classLoaderManager;
        this._logStrategy.configureLogging();
        this._classLoaderManager.initClassLoaders();
        this._managerListener = new HashSet<IPluginManagerListener>();
        this._moduleManager.registerLayerListener(new ServiceLookupInfrastructure.LayerServicesListener(ServiceLookupInfrastructure.getInstance()));
        this.initLocationFinders();
        this._container = new Container();
        this._container.set(PluginManager.class, this);
        this._container.set(ServiceContainer.class, this._container);
        this._container.set(ClassLoaderManager.class, this._classLoaderManager);
        this._loader = new PluginLoaderComposition(this._moduleManager);
        PluginClassLoader loader = this.getPluginClassLoader();
        this._loader.addLoader(new SimplePluginLoader(loader, this._container));
        this._loader.addLoader(new DIPluginLoader(loader, this._container));
        this._commands.put("", new NoOpCommand());
        this._commands.put("help", new HelpCommand());
        this._commands.put("exit", new ExitCommand());
        this._commands.put("load", new LoadCommand());
        this._commands.put("list", new ListCommand());
        this._commands.put("unload", new UnloadCommand());
        this._commands.put("info", new InfoCommand());
        this._commands.put("script", new ScriptCommand());
        this._commands.put("gc", new GCCommand());
        this._commands.put("get", new GetPropertyCommand());
        this._commands.put("set", new SetPropertyCommand());
        this._commands.put("packageCount", this._classLoaderManager.getPluginClassLoader().new PluginClassLoader.PackageCountCommand());
        this._commands.put("sleep", new SleepCommand());
    }

    public static synchronized PluginManager getInstance() {
        if (_instance == null) {
            PluginManager.createInstance(PluginManager.getDefaultLoaderLocation(), PluginManager.getDefaultLogStrategy(), PluginManager.getDefaultClassLoaderManager());
        }
        return _instance;
    }

    private static synchronized PluginManager createInstance(URL url, LogStrategy logStrategy, ClassLoaderManager classLoaderManager) {
        if (_instance != null) {
            throw new IllegalStateException("Cannot create PluginManager singleton, is already there.");
        }
        _instance = new PluginManager(url, logStrategy, classLoaderManager);
        _instance.initPlugins();
        return _instance;
    }

    public void addPluginManagerListener(IPluginManagerListener l) {
        this._managerListener.add(l);
    }

    public void removePluginManagerListener(IPluginManagerListener l) {
        this._managerListener.remove(l);
    }

    public ServiceContainer getServiceContainer() {
        return this._container;
    }

    private void serviceAdded(Collection<String> services, IPlugin provider) {
        for (IPluginManagerListener listener : this._managerListener) {
            for (String service : services) {
                listener.serviceAdded(service, provider);
            }
        }
    }

    private void serviceRemoved(Collection<String> services, IPlugin provider) {
        for (IPluginManagerListener listener : this._managerListener) {
            for (String service : services) {
                listener.serviceRemoved(service, provider);
            }
        }
    }

    public void addPlugin(IPlugin plugin, boolean isModular) throws DependencyNotFulfilledException {
        block5: {
            if (!this.checkDependenciesFulfilled(plugin)) {
                throw new DependencyNotFulfilledException("Cannot add " + String.valueOf(plugin));
            }
            try {
                LOGGER.debug((Object)("************ INITIALIZING " + plugin.getName() + " ********"));
                plugin.init();
                this._dependencyList.addElement(DependencyCheckList.DependencyElement.create(plugin));
                if (isModular) {
                    this.registerPluginAsModular(plugin);
                }
                this.serviceAdded(plugin.getProperties().getProvisions(), plugin);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error((Object)("PluginManager: adding of " + String.valueOf(plugin) + " failed: " + String.valueOf(e) + "\n Plugin location: " + String.valueOf(plugin.getProperties().getURL())));
                LOGGER.debug((Object)e.toString(), e);
                if (this.serviceContainerContainsMainClass(plugin)) {
                    this._container.unbind(plugin.getClass());
                }
                if (!isModular) break block5;
                this._moduleManager.removeLayerOfPlugin(plugin.getName());
                this.unregisterModularPlugin(plugin);
            }
        }
    }

    private boolean serviceContainerContainsMainClass(IPlugin plugin) {
        if (plugin.getProperties().getMainClass().isBlank()) {
            return false;
        }
        return this._container.has(plugin.getClass());
    }

    public synchronized boolean checkDependenciesFulfilled(PluginProperties props) {
        return this._dependencyList.dependencyFulfilled(DependencyCheckList.DependencyElement.create(props));
    }

    public synchronized boolean checkDependenciesFulfilled(IPlugin plugin) {
        return this._dependencyList.dependencyFulfilled(DependencyCheckList.DependencyElement.create(plugin));
    }

    public IPlugin getPluginByName(String pluginName) {
        IPlugin found = null;
        pluginName = pluginName.replaceAll("_", " ").trim();
        LOGGER.debug((Object)("PluginManager looking for " + pluginName));
        List<IPlugin> plugins = this.getPlugins();
        for (IPlugin plugin : plugins) {
            if (!plugin.getName().equals(pluginName)) continue;
            found = plugin;
            break;
        }
        if (found == null) {
            found = this.getPluginByAlias(pluginName);
        }
        return found;
    }

    public IPlugin getPluginByClass(Class<?> clazz) {
        LOGGER.debug((Object)("PluginManager looking for " + clazz.getName()));
        try {
            Object o = this._container.get(clazz);
            if (o instanceof IPlugin) {
                return (IPlugin)o;
            }
            return null;
        }
        catch (MissingDependencyException e) {
            return null;
        }
    }

    public IPlugin getPluginByAlias(String pluginAlias) {
        IPlugin found = null;
        LOGGER.debug((Object)("PluginManager looking for " + pluginAlias));
        List<IPlugin> plugins = this.getPlugins();
        for (int i = 0; i < plugins.size(); ++i) {
            IPlugin current = plugins.get(i);
            if (!pluginAlias.equals(current.getAlias())) continue;
            found = current;
            break;
        }
        return found;
    }

    public Collection<IPlugin> getPluginsProviding(String service) {
        Vector<IPlugin> result = new Vector<IPlugin>();
        for (IPlugin plugin : this.getPlugins()) {
            if (!plugin.getProperties().getProvisions().contains(service)) continue;
            result.add(plugin);
        }
        return result;
    }

    public Collection<IPlugin> getPluginsRequiring(String service) {
        Vector<IPlugin> result = new Vector<IPlugin>();
        block0: for (IPlugin p : this.getPlugins()) {
            if (p.getProperties().getRequirements().contains(service)) {
                result.add(p);
                continue;
            }
            for (String requirement : p.getProperties().getRequirements()) {
                if (!requirement.startsWith(service)) continue;
                result.add(p);
                continue block0;
            }
        }
        return result;
    }

    public void initPlugins() {
        for (IPlugin p : this.getPlugins()) {
            LOGGER.debug((Object)("initializing " + p.getName() + ", loaded from " + String.valueOf(p.getClass().getClassLoader())));
            LOGGER.debug((Object)("************ INITIALIZING " + p.getName() + " ********"));
            p.init();
            this.serviceAdded(p.getProperties().getProvisions(), p);
        }
    }

    public PluginClassLoader getPluginClassLoader() {
        return this._classLoaderManager.getPluginClassLoader();
    }

    public ClassLoader getModuleClassLoaderForClass(String name) {
        return this._moduleManager.getModuleClassLoaderForClass(name);
    }

    public ClassLoader getBottomClassLoader() {
        return this._classLoaderManager.getBottomClassLoader();
    }

    public ClassLoader getNewBottomClassLoader() {
        return this._classLoaderManager.getNewBottomClassLoader();
    }

    public ClassLoader getSystemClassLoader() {
        return this._classLoaderManager.getSystemClassLoader();
    }

    PluginLoaderComposition getPluginLoader() {
        return this._loader;
    }

    public synchronized void loadPlugins() {
        this._loader.loadPlugins();
    }

    public synchronized IPlugin loadPlugin(URL url) {
        return this._loader.loadPluginFromURL(url);
    }

    public List<IPlugin> getPlugins() {
        return this._dependencyList.getFulfilledObjects();
    }

    private void registerPluginAsModular(IPlugin plugin) {
        this._modularPlugins.add(plugin);
    }

    private void unregisterModularPlugin(IPlugin plugin) {
        this._modularPlugins.remove(plugin);
    }

    private boolean isModularPlugin(IPlugin plugin) {
        return this._modularPlugins.contains(plugin);
    }

    public void addCLCommand(String command, CLCommand cLCommand) {
        this._commands.put(command, cLCommand);
        this.notifyCommandAdded(command, cLCommand);
    }

    public void removeCLCommand(String command) {
        this._commands.remove(command);
        this.notifyCommandRemoved(command);
    }

    public Map<String, CLCommand> getCLCommands() {
        return this._commands;
    }

    public void blockExit(IPlugin blocker) {
        if (blocker != null) {
            LOGGER.debug((Object)("PluginManager: registering exit blocker " + String.valueOf(blocker)));
            this._blockers.add(blocker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitOk(IPlugin blocker) {
        Set<IPlugin> set = this._blockers;
        synchronized (set) {
            if (blocker != null) {
                LOGGER.debug((Object)("PluginManager: unregistering exit blocker " + String.valueOf(blocker)));
                this._blockers.remove(blocker);
            }
            this.checkExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExit() {
        Set<IPlugin> set = this._blockers;
        synchronized (set) {
            if (this._blockers.isEmpty()) {
                LOGGER.debug((Object)"PluginManager: no active plugins, shutting down.");
                this.stop();
                return true;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Active plugins blocking exit: " + CollectionLister.toString(this._blockers)));
            }
        }
        return false;
    }

    public void stop() {
        LOGGER.debug((Object)"Initiating PluginManager termination.");
        Thread terminationThread = new Thread(){

            @Override
            public void run() {
                if (PluginManager.this.stopSynchronized()) {
                    System.exit(0);
                }
            }
        };
        terminationThread.start();
    }

    public void stop(final IPlugin p) {
        LOGGER.debug((Object)("Initiating termination of " + String.valueOf(p) + "."));
        Thread terminationThread = new Thread(){

            @Override
            public void run() {
                PluginManager.this.stopSynchronized(p);
            }
        };
        terminationThread.start();
    }

    public CompletableFuture<Boolean> stop(final List<IPlugin> plugins) {
        LOGGER.debug((Object)("Initiating termination of " + String.valueOf(plugins) + "."));
        final CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        Thread terminationThread = new Thread(){

            @Override
            public void run() {
                boolean result = PluginManager.this.stopSynchronized(plugins);
                completableFuture.complete(result);
            }
        };
        terminationThread.start();
        return completableFuture;
    }

    public void blockingStop(List<IPlugin> plugins) {
        LOGGER.debug((Object)("Initiating termination of " + String.valueOf(plugins) + "."));
        this.stopSynchronized(plugins);
    }

    public boolean isStopping() {
        return this._terminating;
    }

    public synchronized boolean stopSynchronized() {
        LOGGER.debug((Object)"Stopping plugin system asynchronously.");
        this._terminating = true;
        try {
            List<IPlugin> pls = this._dependencyList.getFulfilledObjects();
            boolean bl = this.stopSynchronized(pls);
            return bl;
        }
        finally {
            this._terminating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean stopSynchronized(List<IPlugin> pls) {
        IPlugin toStop;
        int i;
        for (i = pls.size() - 1; i >= 0; --i) {
            SynchronizedThread ct;
            block21: {
                int waitSeconds;
                toStop = pls.get(i);
                Object sync = new Object();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Preparing stop of " + String.valueOf(toStop)));
                }
                int firstWait = waitSeconds = toStop.getProperties().getIntProperty("cleanupTimeout", 20000);
                int secondWait = 1;
                if (waitSeconds > 10) {
                    firstWait = waitSeconds / 10;
                    secondWait = waitSeconds - firstWait;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("canShutDown timeout is " + waitSeconds + " milliseconds (" + firstWait + "/" + secondWait + ")."));
                }
                ct = new SynchronizedThread(() -> toStop.canShutDown(), sync);
                try {
                    ct.start();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Started canShutDown thread, syncing on " + String.valueOf(sync)));
                    }
                    Object object = sync;
                    synchronized (object) {
                        if (!ct.didFinish()) {
                            if (waitSeconds == -1) {
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace((Object)("Waiting (unlimited) for canShutDown thread to finish, synced on " + String.valueOf(sync)));
                                }
                                sync.wait();
                            } else {
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace((Object)("Waiting (first part) for canShutDown thread to finish, synced on " + String.valueOf(sync)));
                                }
                                sync.wait(firstWait);
                                if (!ct.didFinish()) {
                                    LOGGER.info((Object)("Waiting for " + String.valueOf(toStop) + " to confirm termination..."));
                                    sync.wait(secondWait);
                                }
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace((Object)("Done waiting, canShutDown thread " + (ct.didFinish() ? "finished" : "did not finish") + ", synced on " + String.valueOf(sync)));
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isTraceEnabled()) break block21;
                    LOGGER.trace((Object)("Interrupted timeout waiting on " + String.valueOf(sync)));
                }
            }
            if (!ct.hadSuccess()) {
                LOGGER.warn((Object)(String.valueOf(toStop) + " did not confirm termination in time."));
                return false;
            }
            LOGGER.debug((Object)(String.valueOf(toStop) + " said it can shut down."));
        }
        for (i = pls.size() - 1; i >= 0; --i) {
            toStop = pls.get(i);
            try {
                this._dependencyList.removeElement(toStop);
                LOGGER.info((Object)(toStop.getName() + " was unloaded."));
            }
            catch (DependencyNotFulfilledException e) {
                LOGGER.error((Object)e.getMessage());
                LOGGER.error((Object)"list of dependent plugins:");
                LOGGER.error((Object)CollectionLister.toString(e.getElements()));
                return false;
            }
            if (this.stopSynchronized(toStop)) continue;
            LOGGER.warn((Object)("stop cancelled by plugin " + String.valueOf(toStop)));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean stopSynchronized(final IPlugin p) {
        DependencyCheckList<IPlugin> dependencyCheckList;
        PluginAdapter blockLock;
        SynchronizedThread ct;
        block31: {
            try {
                DependencyCheckList<IPlugin> dependencyCheckList2 = this._dependencyList;
                synchronized (dependencyCheckList2) {
                    this._dependencyList.removeElement(p);
                }
            }
            catch (DependencyNotFulfilledException e) {
                LOGGER.error((Object)e.getMessage());
                LOGGER.error((Object)"list of dependent plugins:");
                LOGGER.error((Object)CollectionLister.toString(e.getElements()));
                DependencyCheckList<IPlugin> dependencyCheckList3 = this._dependencyList;
                synchronized (dependencyCheckList3) {
                    this._dependencyList.addElement(DependencyCheckList.DependencyElement.create(p));
                }
                return false;
            }
            LOGGER.debug((Object)("stopping " + String.valueOf(p)));
            DependencyCheckList<IPlugin> sync = new DependencyCheckList<IPlugin>();
            int waitSeconds = p.getProperties().getIntProperty("cleanupTimeout", 20000);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Cleanup timeout is " + waitSeconds + " milliseconds."));
            }
            ct = new SynchronizedThread(new Command(){

                @Override
                public boolean execute() {
                    return p.cleanup();
                }
            }, sync);
            blockLock = new PluginAdapter(PluginProperties.getUserProperties());
            if (!p.getName().equals("Renew Gui")) {
                this._blockers.add(blockLock);
            }
            try {
                ct.start();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Started cleanup thread, syncing on " + String.valueOf(sync)));
                }
                dependencyCheckList = sync;
                synchronized (dependencyCheckList) {
                    if (!ct.didFinish()) {
                        if (waitSeconds == -1) {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace((Object)("Waiting (unlimited) for cleanup thread to finish, synced on " + String.valueOf(sync)));
                            }
                            sync.wait();
                        } else {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace((Object)("Waiting for cleanup thread to finish, synced on " + String.valueOf(sync)));
                            }
                            sync.wait(waitSeconds);
                        }
                    }
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Done waiting, cleanup thread " + (ct.didFinish() ? "finished" : "did not finish") + ", synced on " + String.valueOf(sync)));
                    }
                }
            }
            catch (InterruptedException e) {
                if (!LOGGER.isTraceEnabled()) break block31;
                LOGGER.trace((Object)("Interrupted timeout waiting on " + String.valueOf(sync)));
            }
        }
        if (!p.getName().equals("Renew Gui")) {
            this._blockers.remove(blockLock);
        }
        LOGGER.debug((Object)(String.valueOf(p) + " stopped"));
        boolean result = ct.hadSuccess();
        if (!result) {
            dependencyCheckList = this._dependencyList;
            synchronized (dependencyCheckList) {
                this._dependencyList.addElement(DependencyCheckList.DependencyElement.create(p));
            }
        } else {
            this.serviceRemoved(p.getProperties().getProvisions(), p);
            if (this.serviceContainerContainsMainClass(p)) {
                this._container.unbind(p.getClass());
            }
            if (this.isModularPlugin(p)) {
                this._moduleManager.removeLayerOfPlugin(p.getName());
                this.unregisterModularPlugin(p);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        PluginManager.main(args, null);
    }

    public static void main(String[] args, URL url) {
        PluginManager.main(args, url, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args, URL url, LogStrategy logStrategy, ClassLoaderManager classLoaderManager) {
        for (String string : args) {
            System.out.println(string);
        }
        if (url != null) {
            _loaderLocation = url;
        }
        PluginManager pm = PluginManager.createInstance(url, logStrategy, classLoaderManager);
        pm.loadPlugins();
        for (IPlugin plugin : pm.getPlugins()) {
            plugin.startUpComplete(true);
            LOGGER.info((Object)("loaded plugin: " + plugin.getName()));
        }
        if (args.length > 0) {
            ArrayList cmds = new ArrayList();
            cmds.add(new ArrayList());
            for (int i = 0; i < args.length; ++i) {
                void var7_13;
                String string = args[i];
                if (string.equals(COMMAND_SEPERATOR)) {
                    cmds.add(new ArrayList());
                    continue;
                }
                if (string.matches("^\\s*$")) continue;
                while (var7_13.contains(COMMAND_SEPERATOR)) {
                    int indexOf = var7_13.indexOf(COMMAND_SEPERATOR);
                    String left = var7_13.substring(0, indexOf);
                    String right = var7_13.substring(indexOf + COMMAND_SEPERATOR.length());
                    ((List)cmds.get(cmds.size() - 1)).add(left);
                    cmds.add(new ArrayList());
                    String string2 = right;
                }
                ((List)cmds.get(cmds.size() - 1)).add(var7_13);
            }
            for (List list : cmds) {
                if (list.size() == 0) continue;
                CLCommand c = pm._commands.get(list.get(0));
                if (c == null) {
                    for (String s : list) {
                        System.out.println("#" + s + "#");
                    }
                    LOGGER.warn((Object)("Unknown initial command (ignored): " + String.valueOf(list)));
                    continue;
                }
                list.remove(0);
                String[] nc = new String[list.size()];
                nc = list.toArray(nc);
                LOGGER.debug((Object)("Executing initial command: " + String.valueOf(list)));
                c.execute(nc, System.out);
            }
        }
        pm.checkExit();
    }

    public static synchronized void configureLogging() {
        if (_instance != null) {
            PluginManager._instance._logStrategy.configureLogging();
        } else {
            PluginManager.getDefaultLogStrategy().configureLogging();
        }
    }

    private void initLocationFinders() {
        URL url = PluginManager.getLoaderLocation();
        try {
            url = new URL(url, "plugins/");
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("Could not deduce plugins directory near plugin loader: " + String.valueOf(e)));
            try {
                url = new URL(new File(System.getProperty("user.dir")).toURI().toURL(), "plugins/");
            }
            catch (MalformedURLException e2) {
                LOGGER.error((Object)("Could not deduce plugins directory near current directory: " + String.valueOf(e2)));
                return;
            }
        }
        this._locationFinder.addLocationFinder(new PluginSubDirFinder(url));
        this._locationFinder.addLocationFinder(new PluginJarLocationFinder(url));
        Iterator<URL> fromFile = this.getLocations();
        while (fromFile.hasNext()) {
            url = fromFile.next();
            this._locationFinder.addLocationFinder(new PluginSubDirFinder(url));
            this._locationFinder.addLocationFinder(new PluginJarLocationFinder(url));
        }
    }

    public Iterator<URL> getLocations() {
        Vector<URL> result = new Vector<URL>();
        PluginProperties userProps = PluginProperties.getUserProperties();
        if (userProps.getProperty(PLUGIN_LOCATIONS_PROPERTY) == null) {
            LOGGER.info((Object)"no additional plugin locations set.");
        }
        Collection<String> locations = PropertyHelper.parsePathListString(userProps.getProperty(PLUGIN_LOCATIONS_PROPERTY, ""));
        for (String file : locations) {
            LOGGER.debug((Object)("location: " + file));
            URL url = this.createURLFromString(file);
            if (url == null) continue;
            LOGGER.debug((Object)("as URL: " + String.valueOf(url)));
            result.add(url);
        }
        return result.iterator();
    }

    private URL createURLFromString(String str) {
        URL url = null;
        File file = new File(str);
        if (file.exists()) {
            try {
                url = file.toURI().toURL();
                return url;
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            url = new URI(str).toURL();
        }
        catch (IllegalArgumentException | NullPointerException | MalformedURLException | URISyntaxException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("Neither file nor url: " + str + "(" + String.valueOf(e) + ")"), (Throwable)e);
            }
            LOGGER.warn((Object)("Neither file nor url: " + str));
        }
        return url;
    }

    public List<String> getMissingDependencies(PluginProperties props) {
        ArrayList<String> dependencyList = new ArrayList<String>(this._dependencyList.getFulfilledProvisions());
        DependencyCheckList.DependencyElement<PluginProperties> dependencyElement = DependencyCheckList.DependencyElement.create(props);
        return dependencyElement.getMissingRequirements(dependencyList);
    }

    public URL[] getLibs() {
        URLClassLoader urlCL;
        try {
            urlCL = (URLClassLoader)this.getSystemClassLoader();
        }
        catch (ClassCastException e) {
            LOGGER.warn((Object)"Could not extract URL from SystemClassLoader, no URLClassLoader.", (Throwable)e);
            return null;
        }
        return urlCL.getURLs();
    }

    public List<String> getDependentPlugins(IPlugin plugin) {
        ArrayList<String> dependentPlugins = new ArrayList<String>();
        for (DependencyCheckList.DependencyElement<IPlugin> dependency : this._dependencyList.getDependentPlugins(plugin)) {
            dependentPlugins.add(dependency.getPluginName());
        }
        return dependentPlugins;
    }

    public static File getPreferencesLocation() {
        File dir = new File(System.getProperty("user.home") + File.separator + PREF_DIR);
        if (!dir.exists() && !dir.mkdir()) {
            return null;
        }
        return dir;
    }

    @Override
    public void addCommandListener(CommandsListener listener) {
        this._commandsListener.add(listener);
    }

    @Override
    public void removeCommandListener(CommandsListener listener) {
        this._commandsListener.remove(listener);
    }

    @Override
    public void notifyCommandAdded(String name, CLCommand command) {
        for (CommandsListener cListener : this._commandsListener) {
            cListener.commandAdded(name, command);
        }
    }

    @Override
    public void notifyCommandRemoved(String name) {
        for (CommandsListener cListener : this._commandsListener) {
            cListener.commandRemoved(name);
        }
    }

    public class HelpCommand
    implements CLCommand {
        @Override
        public void execute(String[] args, PrintStream response) {
            response.println("usage: {command {args}* ---}*");
            response.println("available commands:");
            int largestKeySize = 0;
            for (String key : PluginManager.this._commands.keySet()) {
                largestKeySize = Math.max(largestKeySize, key.length());
            }
            String space = this.stringRepeat(" ", largestKeySize + 5);
            for (String key : PluginManager.this._commands.keySet()) {
                CLCommand command = PluginManager.this._commands.get(key);
                String additionalSpace = this.stringRepeat(" ", largestKeySize - key.length() + 2);
                response.print(key + additionalSpace + "-  ");
                String description = command.getDescription();
                description = description.replaceAll("\n", "\n" + space);
                response.println(description);
            }
        }

        private String stringRepeat(String str, int times) {
            Object result = "";
            if (times > 0) {
                for (int i = 0; i < times; ++i) {
                    result = (String)result + str;
                }
            }
            return result;
        }

        @Override
        public String getDescription() {
            return "print a list of all commands";
        }

        @Override
        public String getArguments() {
            return null;
        }
    }

    private static class SynchronizedThread
    extends Thread {
        private boolean _success = false;
        private boolean _finished = false;
        private Object _toNotify;
        private Command _toExecute;

        public SynchronizedThread(Command toExecute, Object toNotify) {
            this._toExecute = toExecute;
            this._toNotify = toNotify;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._success = this._toExecute.execute();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Execution finished: 1) syncing on " + String.valueOf(this._toNotify)));
            }
            Object object = this._toNotify;
            synchronized (object) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Execution finished: 2) notifying on " + String.valueOf(this._toNotify)));
                }
                this._finished = true;
                this._toNotify.notify();
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Execution finished: 3) done on " + String.valueOf(this._toNotify)));
            }
        }

        public boolean hadSuccess() {
            return this._success;
        }

        public boolean didFinish() {
            return this._finished;
        }
    }

    private static interface Command {
        public boolean execute();
    }
}

