/*
 * Decompiled with CFR 0.152.
 */
package de.renew.propertymanagement;

import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.propertymanagement.commands.GetConfigurablePropertiesCommand;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;
import de.renew.propertymanagement.prop.PropertyLoadFailedException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.log4j.Logger;

public class PropertyManagementPlugin
extends PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(PropertyManagementPlugin.class);
    private static final String UI_SCALE_PROPERTY = "sun.java2d.uiScale";

    public PropertyManagementPlugin(URL location) throws PluginException {
        super(location);
    }

    public PropertyManagementPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        ConfigurablePropertyManager propertyManager = ConfigurablePropertyManager.getInstance();
        propertyManager.addConfigurableProperty(UI_SCALE_PROPERTY, "1", "Renew Window Management", "UI Scale", null);
        try {
            propertyManager.loadProperties(false);
            propertyManager.loadProperties(true);
            Optional<String> prop = Optional.ofNullable(System.getProperty(UI_SCALE_PROPERTY));
            if (prop.isEmpty()) {
                prop = propertyManager.getCurrentValueForProperty(UI_SCALE_PROPERTY);
            }
            prop.ifPresent(value -> System.setProperty(UI_SCALE_PROPERTY, value));
        }
        catch (PropertyLoadFailedException | NoSuchElementException e) {
            LOGGER.error((Object)"Could not load property file.", (Throwable)e);
        }
        PluginManager pm = PluginManager.getInstance();
        if (pm != null) {
            pm.addCLCommand("listConfigurableProperties", (CLCommand)new GetConfigurablePropertiesCommand());
        }
    }

    public boolean cleanup() {
        PluginManager pm = PluginManager.getInstance();
        if (pm == null) {
            return false;
        }
        pm.removeCLCommand("listConfigurableProperties");
        return true;
    }
}

