/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.call.JavaCharStream;
import de.renew.call.ParseException;
import de.renew.call.StubParserConstants;
import de.renew.call.StubParserTokenManager;
import de.renew.call.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class StubParser
implements StubParserConstants {
    String className;
    String netName;
    Set<String> variables;
    Set<String> assignedVariables;
    Hashtable<String, String> variableTypes;
    Set<String> getternames;
    Set<String> setternames;
    StringBuffer out = new StringBuffer();
    String pckg = "";
    public StubParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[24];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    void out(String output) {
        this.out.append(output);
        this.out.append("\n");
    }

    public String getPackage() {
        return this.pckg;
    }

    public String getOutput() {
        return this.out.toString();
    }

    ParseException makeParseException(String msg) {
        return new ParseException("Error in line " + this.token.beginLine + ", column " + this.token.beginColumn + ":\n" + msg);
    }

    void addGetterName(String name) throws ParseException {
        if (this.getternames == null) {
            this.getternames = new HashSet<String>();
        }
        if (this.getternames.contains(name)) {
            throw this.makeParseException("Getter declared twice: " + name);
        }
        this.getternames.add(name);
    }

    void addSetterName(String name) throws ParseException {
        if (this.setternames == null) {
            this.setternames = new HashSet<String>();
        }
        if (this.setternames.contains(name)) {
            throw this.makeParseException("Setter declared twice: " + name);
        }
        this.setternames.add(name);
    }

    void variableInit() {
        this.variables = new HashSet<String>();
        this.assignedVariables = new HashSet<String>();
        this.variableTypes = new Hashtable();
    }

    void declareVariable(String type, String variable) throws ParseException {
        if (this.variables.contains(variable)) {
            if (this.variableTypes.containsKey(variable)) {
                throw this.makeParseException("Variable declared twice: " + variable);
            }
            throw this.makeParseException("Variable declared after use: " + variable);
        }
        this.variables.add(variable);
        if (type != null) {
            this.variableTypes.put(variable, type);
        }
    }

    String getInternalName(String variable) throws ParseException {
        if (!this.variables.contains(variable)) {
            if (variable.equals("this")) {
                return "_instance";
            }
            throw this.makeParseException("No such variable: " + variable);
        }
        return "vv" + variable;
    }

    String getParameterName(String variable) throws ParseException {
        return "pp" + variable;
    }

    boolean isPrimitive(String type) {
        return (type = type.intern()) == "boolean" || type == "char" || type == "byte" || type == "short" || type == "int" || type == "long" || type == "float" || type == "double";
    }

    String getObjectType(String type) {
        if ((type = type.intern()) == "boolean") {
            return "java.lang.Boolean";
        }
        if (type == "char") {
            return "java.lang.Character";
        }
        if (type == "byte") {
            return "java.lang.Byte";
        }
        if (type == "short") {
            return "java.lang.Short";
        }
        if (type == "int") {
            return "java.lang.Integer";
        }
        if (type == "long") {
            return "java.lang.Long";
        }
        if (type == "float") {
            return "java.lang.Float";
        }
        if (type == "double") {
            return "java.lang.Double";
        }
        return "java.lang.Void";
    }

    String getTypeString(String variable) {
        String type = this.variableTypes.get(variable);
        if (this.isPrimitive(type)) {
            return this.getObjectType(type) + ".TYPE";
        }
        return type + ".class";
    }

    public final void StubFile() throws ParseException {
        boolean hasConstructor;
        block36: {
            hasConstructor = false;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: {
                    this.PackageClause();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 34: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block21;
                    }
                }
                this.ImportClause();
            }
            this.out("import java.util.concurrent.Callable;");
            this.out("import java.util.concurrent.ExecutionException;");
            this.out("import java.util.concurrent.Future;");
            this.out("import java.util.Set;");
            this.out("import java.util.Collection;");
            this.out("");
            this.out("import de.renew.engine.thread.SimulationThreadPool;");
            this.out("import de.renew.net.NetInstance;");
            this.out("import de.renew.net.Place;");
            this.out("import de.renew.net.PlaceInstance;");
            this.out("import de.renew.net.SimulatablePlaceInstance;");
            this.out("import de.renew.engine.searchqueue.SearchQueue;");
            Token s = this.jj_consume_token(17);
            Token t = this.jj_consume_token(69);
            this.className = t.image;
            if (s.specialToken != null) {
                this.out(s.specialToken.image);
            }
            this.out("public class " + t.image);
            this.jj_consume_token(29);
            if (this.jj_2_1(2)) {
                t = this.jj_consume_token(69);
                Token t2 = this.jj_consume_token(69);
                if (!t.image.equals("net")) {
                    throw this.makeParseException("Expected 'for net <netname>' or 'for netinstance', encountered 'for " + t.image + " " + t2.image + "'");
                }
                this.out("  extends de.renew.net.NetInstanceImpl");
                this.netName = t2.image;
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        t = this.jj_consume_token(69);
                        if (!t.image.equals("netinstance")) {
                            throw this.makeParseException("Expected 'for net <netname>' or 'for netinstance', encountered 'for " + t.image + "'");
                        }
                        this.netName = null;
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    String name = this.Name();
                    Object implementsList = name;
                    block22: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 79: {
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                break block22;
                            }
                        }
                        this.jj_consume_token(79);
                        name = this.Name();
                        implementsList = (String)implementsList + ", " + name;
                    }
                    this.out("  implements " + (String)implementsList);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                }
            }
            this.jj_consume_token(74);
            this.out("{");
            this.out("");
            this.out("  private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger");
            this.out("                                                        .getLogger(" + this.className + ".class);");
            if (this.netName == null) {
                this.out("  private final NetInstance _instance;");
            } else {
                this.out("  private final NetInstance _instance = this;");
            }
            this.out("");
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 16: 
                    case 22: 
                    case 28: 
                    case 36: 
                    case 38: 
                    case 47: 
                    case 58: 
                    case 69: 
                    case 118: 
                    case 119: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block36;
                    }
                }
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    this.ConstructorDeclaration();
                    hasConstructor = true;
                    continue;
                }
                if (this.jj_2_3(2)) {
                    this.PlaceAccessDeclaration();
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 16: 
                    case 22: 
                    case 28: 
                    case 36: 
                    case 38: 
                    case 47: 
                    case 58: 
                    case 69: {
                        this.MethodDeclaration();
                        continue block23;
                    }
                }
                break;
            }
            this.jj_la1[6] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(75);
        this.jj_consume_token(0);
        if (!hasConstructor) {
            if (this.netName == null) {
                this.out("  public " + this.className + "(NetInstance instance)");
                this.out("  {");
                this.out("    _instance = instance;");
                this.out("  }");
            } else {
                this.out("  public " + this.className + "()");
                this.out("  {");
                this.out("    super();");
                this.out("    Future<Object> future = SimulationThreadPool.getCurrent()");
                this.out("                                 .submitAndWait(new Callable<Object>() {");
                this.out("      public Object call() throws RuntimeException {");
                this.out("        try {");
                this.out("          de.renew.net.Net net = new de.renew.net.NetLookup().findForName(\"" + this.netName + "\");");
                this.out("          net.setEarlyTokens(true);");
                this.out("          initNet(net, true);");
                this.out("          createConfirmation(de.renew.simulator.api.SimulationManager.getCurrentSimulator().currentStepIdentifier());");
                this.out("        } catch (de.renew.simulatorontology.loading.NetNotFoundException e) {");
                this.out("          throw new RuntimeException(e.toString(), e);");
                this.out("        } catch (de.renew.unify.Impossible e) {");
                this.out("          throw new RuntimeException(e.toString(), e);");
                this.out("        }");
                this.out("        return null;");
                this.out("      }");
                this.out("    });");
                this.out("    try {");
                this.out("        future.get();");
                this.out("    } catch (InterruptedException e) {");
                this.out("        logger.error(\"Timeout while waiting for simulation thread to finish\", e);");
                this.out("    } catch (ExecutionException e) {");
                this.out("        logger.error(\"Simulation thread threw an exception\", e);");
                this.out("    }");
                this.out("  }");
            }
        }
        this.out("}");
    }

    public final void PackageClause() throws ParseException {
        this.jj_consume_token(42);
        this.pckg = this.Name();
        this.jj_consume_token(78);
        this.out("package " + this.pckg + ";");
    }

    public final void ImportClause() throws ParseException {
        boolean star = false;
        this.jj_consume_token(34);
        String name = this.Name();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 80: {
                this.jj_consume_token(80);
                this.jj_consume_token(98);
                star = true;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(78);
        if (star) {
            this.out("import " + name + ".*;");
        } else {
            this.out("import " + name + ";");
        }
    }

    public final void PlaceAccessDeclaration() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 118: {
                this.PlaceGetterDeclaration();
                break;
            }
            case 119: {
                this.PlaceSetterDeclaration();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PlaceGetterDeclaration() throws ParseException {
        Token s = this.jj_consume_token(118);
        Token t = this.jj_consume_token(68);
        this.jj_consume_token(78);
        String name = t.image.replaceAll("\\s", "");
        name = name.replaceAll("\\W", "");
        this.addGetterName(name);
        if (s.specialToken != null) {
            this.out(s.specialToken.image);
        }
        this.out("public Set<Object> get" + name + "()");
        this.out("{");
        this.out("      Set<Object> result = null;");
        this.out("      Collection<Place> places = _instance.getNet().places();");
        this.out("      Place place = null;");
        this.out("      for (Place p : places) {");
        this.out("          if (p.getName().equals(" + t.image + ")) {");
        this.out("              place = p;");
        this.out("              break;");
        this.out("          }");
        this.out("      }");
        this.out("      PlaceInstance placeInstance = null;");
        this.out("      if (place != null) {");
        this.out("          placeInstance = _instance.getInstance(place);");
        this.out("      }");
        this.out("      if (placeInstance != null) {");
        this.out("          result = placeInstance.getDistinctTokens();");
        this.out("      }");
        this.out("      return result;");
        this.out("}");
    }

    public final void PlaceSetterDeclaration() throws ParseException {
        Token s = this.jj_consume_token(119);
        Token t = this.jj_consume_token(68);
        this.jj_consume_token(78);
        String name = t.image.replaceAll("\\s", "");
        name = name.replaceAll("\\W", "");
        this.addSetterName(name);
        if (s.specialToken != null) {
            this.out(s.specialToken.image);
        }
        this.out("public void set" + name + "(Object o)");
        this.out("{");
        this.out("      Collection<Place> places = _instance.getNet().places();");
        this.out("      Place place = null;");
        this.out("      for (Place p : places) {");
        this.out("          if (p.getName().equals(" + t.image + ")) {");
        this.out("              place = p;");
        this.out("              break;");
        this.out("          }");
        this.out("      }");
        this.out("      if (place != null) {");
        this.out("          SimulatablePlaceInstance placeInstance = (SimulatablePlaceInstance) _instance.getInstance(place);");
        this.out("          placeInstance.insertToken(o,SearchQueue.getTime());");
        this.out("      }");
        this.out("}");
    }

    public final void MethodDeclaration() throws ParseException {
        String type;
        boolean isBreak = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11, 13, 16, 22, 28, 36, 38, 47, 69 -> {
                type = this.Type();
                yield false;
            }
            case 58 -> {
                Token s = this.jj_consume_token(58);
                if (s.specialToken != null) {
                    this.out(s.specialToken.image);
                }
                type = "void";
                yield false;
            }
            case 12 -> {
                Token s = this.jj_consume_token(12);
                this.jj_consume_token(58);
                if (s.specialToken != null) {
                    this.out(s.specialToken.image);
                }
                type = "void";
                yield true;
            }
            default -> {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        Token t = this.jj_consume_token(69);
        this.variableInit();
        this.Params("public " + type + " " + t.image, null, null);
        this.assignedVariables.add("this");
        if (!type.equals("void")) {
            this.declareVariable(type, "return");
            String tmpType = type;
            if (this.isPrimitive(type)) {
                tmpType = this.getObjectType(type);
            }
            this.out("      Future<" + tmpType + "> future = SimulationThreadPool.getCurrent()");
            this.out("                                   .submitAndWait(new Callable<" + tmpType + ">() {");
            this.out("        public " + tmpType + " call() throws RuntimeException {");
            this.out("          Object " + this.getInternalName("return") + ";");
        } else if (isBreak) {
            this.out("      SimulationThreadPool.getCurrent().execute(new Runnable() {");
            this.out("        public void run() {");
        } else {
            this.out("      SimulationThreadPool.getCurrent().executeAndWait(new Runnable() {");
            this.out("        public void run() {");
        }
        this.MethodBody("            ");
        if (!type.equals("void")) {
            if (!this.assignedVariables.contains("return")) {
                throw this.makeParseException("Pseudo-variable return unassigned at end of method.");
            }
            if (this.isPrimitive(type)) {
                this.out("            return ((de.renew.util.Value)" + this.getInternalName("return") + ")." + type + "Value();");
            } else {
                this.out("            return (" + type + ")" + this.getInternalName("return") + ";");
            }
        }
        this.out("        }");
        this.out("      });");
        if (!type.equals("void")) {
            this.out("      try {");
            this.out("          return future.get();");
            this.out("      } catch (InterruptedException e) {");
            this.out("          logger.error(\"Timeout while waiting for simulation thread to finish\", e);");
            this.out("      } catch (ExecutionException e) {");
            this.out("          logger.error(\"Simulation thread threw an exception\", e);");
            this.out("      }");
            this.out("");
            this.out("      // We should never return nothing but some error occured befor.");
            if (type == "boolean") {
                this.out("      return false;");
            } else if (type == "char") {
                this.out("      return \"\\u0000\";");
            } else if (type == "byte" || type == "short" || type == "int" || type == "long" || type == "float" || type == "double") {
                this.out("      return 0;");
            } else {
                this.out("      return null;");
            }
        }
        this.out("  }");
    }

    public final void ConstructorDeclaration() throws ParseException {
        Token t = this.jj_consume_token(69);
        if (!t.image.equals(this.className)) {
            throw this.makeParseException("Constructor name and class name do not match.");
        }
        this.variableInit();
        this.Params("public " + this.className, null, "    super();\n");
        if (this.netName == null) {
            if (!this.variables.contains("instance")) {
                throw this.makeParseException("Custom constructors for netinstance stubs must have an 'instance' parameter taking the NetInstance to be wrapped by the stub.");
            }
            this.out("    _instance = " + this.getInternalName("instance") + ";");
        } else {
            this.out("    Future<Object> future = SimulationThreadPool.getCurrent()");
            this.out("                                 .submitAndWait(new Callable<Object>() {");
            this.out("      public Object call() throws RuntimeException {");
            this.out("        try {");
            this.out("          de.renew.net.Net net = new de.renew.net.NetLookup().findForName(\"" + this.netName + "\");");
            this.out("          net.setEarlyTokens(true);");
            this.out("          initNet(net, true);");
            this.out("          createConfirmation(de.renew.simulator.api.SimulationManager.getCurrentSimulator().currentStepIdentifier());");
            this.out("        } catch (de.renew.simulatorontology.loading.NetNotFoundException e) {");
            this.out("          throw new RuntimeException(e.toString(), e);");
            this.out("        } catch (de.renew.unify.Impossible e) {");
            this.out("          throw new RuntimeException(e.toString(), e);");
            this.out("        }");
            this.out("        return null;");
            this.out("      }");
            this.out("    });");
            this.out("    try {");
            this.out("        future.get();");
            this.out("    } catch (InterruptedException e) {");
            this.out("        logger.error(\"Timeout while waiting for simulation thread to finish\", e);");
            this.out("    } catch (ExecutionException e) {");
            this.out("        logger.error(\"Simulation thread threw an exception\", e);");
            this.out("    }");
        }
        this.assignedVariables.add("this");
        this.MethodBody("    ");
        this.out("  }");
    }

    public final void MethodBody(String indent) throws ParseException {
        block9: {
            this.out(indent + "de.renew.unify.Tuple inTuple;");
            this.out(indent + "de.renew.unify.Tuple outTuple;");
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: 
                    case 13: 
                    case 16: 
                    case 22: 
                    case 28: 
                    case 36: 
                    case 38: 
                    case 46: 
                    case 47: 
                    case 52: 
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block9;
                    }
                }
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    this.DownlinkSpecification(indent);
                    continue;
                }
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    this.VariableAssignment(indent);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: 
                    case 13: 
                    case 16: 
                    case 22: 
                    case 28: 
                    case 36: 
                    case 38: 
                    case 47: 
                    case 69: {
                        this.VariableDeclaration(indent);
                        continue block6;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(75);
    }

    public final void VariableAssignment(String indent) throws ParseException {
        String type = this.Type();
        Token s = this.jj_consume_token(69);
        this.jj_consume_token(81);
        Object expr = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69 -> this.Name();
            case 68 -> {
                Token t = this.jj_consume_token(68);
                yield t.image;
            }
            case 61 -> {
                Token t = this.jj_consume_token(61);
                yield t.image;
            }
            case 67 -> {
                Token t = this.jj_consume_token(67);
                yield t.image;
            }
            case 65 -> {
                Token t = this.jj_consume_token(65);
                yield t.image;
            }
            case 120 -> {
                this.jj_consume_token(120);
                String type2 = this.Type();
                this.jj_consume_token(72);
                Object decl = "";
                block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        Token t = this.jj_consume_token(69);
                        decl = t.image;
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 79: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[12] = this.jj_gen;
                                    break block8;
                                }
                            }
                            this.jj_consume_token(79);
                            t = this.jj_consume_token(69);
                            decl = (String)decl + "," + t.image;
                        }
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                this.jj_consume_token(73);
                yield "new " + type2 + "(" + (String)decl + ")";
            }
            default -> {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.jj_consume_token(78);
        this.declareVariable(type, s.image);
        this.assignedVariables.add(s.image);
        this.out(indent + type + " " + this.getInternalName(s.image) + "=" + (String)expr + ";");
    }

    public final void VariableDeclaration(String indent) throws ParseException {
        String type = this.Type();
        Token t = this.jj_consume_token(69);
        this.declareVariable(type, t.image);
        this.out(indent + "Object " + this.getInternalName(t.image) + ";");
        this.jj_consume_token(78);
    }

    public final void Params(String start, String throwsClause, String firstCmd) throws ParseException {
        this.jj_consume_token(72);
        StringBuffer result = new StringBuffer("  ");
        result.append(start);
        result.append("(");
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: 
            case 13: 
            case 16: 
            case 22: 
            case 28: 
            case 36: 
            case 38: 
            case 47: 
            case 69: {
                String decl = this.Param();
                result.append(decl);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 79: {
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(79);
                    decl = this.Param();
                    result.append(", ");
                    result.append(decl);
                }
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        this.jj_consume_token(73);
        result.append(")");
        this.out(result.toString());
        if (throwsClause != null) {
            this.out(throwsClause);
        }
        this.jj_consume_token(74);
        this.out("  {");
        if (firstCmd != null) {
            this.out(firstCmd);
        }
        for (String variable : this.variables) {
            String type = this.variableTypes.get(variable);
            if (this.isPrimitive(type)) {
                this.out("      final Object " + this.getInternalName(variable) + "=new de.renew.util.Value(new " + this.getObjectType(type) + "(" + this.getParameterName(variable) + "));");
                continue;
            }
            this.out("      final Object " + this.getInternalName(variable) + "=" + this.getParameterName(variable) + ";");
        }
    }

    public final String Param() throws ParseException {
        String type = this.Type();
        Token t = this.jj_consume_token(69);
        this.declareVariable(type, t.image);
        this.assignedVariables.add(t.image);
        return "final " + type + " " + this.getParameterName(t.image);
    }

    public final void DownlinkSpecification(String indent) throws ParseException {
        String var;
        int i;
        Vector<String> channelVariables = new Vector<String>();
        String netVar = this.Variable(indent);
        if (!this.assignedVariables.contains(netVar)) {
            throw this.makeParseException("Variable is unassigned: " + netVar);
        }
        this.jj_consume_token(87);
        String channel = this.ChannelName();
        this.jj_consume_token(72);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: 
            case 52: 
            case 69: {
                String argVar = this.Variable(indent);
                channelVariables.addElement(argVar);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 79: {
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(79);
                    argVar = this.Variable(indent);
                    channelVariables.addElement(argVar);
                }
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(73);
        this.jj_consume_token(78);
        this.out(indent + "inTuple=new de.renew.unify.Tuple(" + channelVariables.size() + ");");
        Hashtable<String, CallSite> components = new Hashtable<String, CallSite>();
        for (i = 0; i < channelVariables.size(); ++i) {
            var = (String)channelVariables.elementAt(i);
            if (this.assignedVariables.contains(var)) {
                this.out(indent + "try {");
                this.out(indent + "  de.renew.unify.Unify.unify(inTuple.getComponent(" + i + ")," + this.getInternalName(var) + ",null);");
                this.out(indent + "} catch (de.renew.unify.Impossible e) {");
                this.out(indent + "  throw new RuntimeException(\"Unification failed unexpectedly.\", e);");
                this.out(indent + "}");
                continue;
            }
            if (components.containsKey(var)) {
                this.out(indent + "try {");
                this.out(indent + "  de.renew.unify.Unify.unify(inTuple.getComponent(" + i + "),");
                this.out(indent + "    inTuple.getComponent(" + (String)components.get(var) + "),null);");
                this.out(indent + "} catch (de.renew.unify.Impossible e) {");
                this.out(indent + "  throw new RuntimeException(\"Unification failed unexpectedly.\", e);");
                this.out(indent + "}");
                continue;
            }
            if (this.variableTypes.containsKey(var)) {
                this.out(indent + "try {");
                this.out(indent + "  de.renew.expression.CallExpression.expressionConstraint(new de.renew.unify.Variable(),");
                this.out(indent + "    new de.renew.formalism.function.CastFunction(" + this.getTypeString(var) + "),");
                this.out(indent + "    new de.renew.unify.Variable(inTuple.getComponent(" + i + "),null),null);");
                this.out(indent + "} catch (de.renew.unify.Impossible e) {");
                this.out(indent + "  throw new RuntimeException(\"Unification failed unexpectedly.\", e);");
                this.out(indent + "}");
            }
            components.put(var, (CallSite)((Object)("" + i)));
        }
        this.out(indent + "outTuple=de.renew.call.SynchronisationRequest.synchronize(");
        this.out(indent + "_instance,\"" + channel + "\",inTuple);");
        this.out("//**only to avoid unused warnings. !BAD! style**");
        this.out(indent + "outTuple.hashCode();");
        for (i = 0; i < channelVariables.size(); ++i) {
            var = (String)channelVariables.elementAt(i);
            if (this.assignedVariables.contains(var)) continue;
            this.out(indent + this.getInternalName(var) + "=outTuple.getComponent(" + i + ");");
            this.assignedVariables.add(var);
        }
    }

    public final String ChannelName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                Token t = this.jj_consume_token(69);
                return t.image;
            }
            case 40: {
                this.jj_consume_token(40);
                return "new";
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Variable(String indent) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                Token t = this.jj_consume_token(69);
                if (!this.variables.contains(t.image)) {
                    this.declareVariable(null, t.image);
                    this.out(indent + "Object " + this.getInternalName(t.image) + ";");
                }
                return t.image;
            }
            case 46: {
                this.jj_consume_token(46);
                if (!this.variables.contains("return")) {
                    throw this.makeParseException("No return in constructor or void method.");
                }
                return "return";
            }
            case 52: {
                this.jj_consume_token(52);
                return "this";
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Type() throws ParseException {
        Object type = this.NonArrayType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(76);
            this.jj_consume_token(77);
            type = (String)type + "[]";
        }
        return type;
    }

    public final String NonArrayType() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11, 13, 16, 22, 28, 36, 38, 47 -> this.PrimitiveType();
            case 69 -> this.Name();
            default -> {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final String PrimitiveType() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11 -> this.jj_consume_token(11);
            case 16 -> this.jj_consume_token(16);
            case 13 -> this.jj_consume_token(13);
            case 47 -> this.jj_consume_token(47);
            case 36 -> this.jj_consume_token(36);
            case 38 -> this.jj_consume_token(38);
            case 28 -> this.jj_consume_token(28);
            case 22 -> this.jj_consume_token(22);
            default -> {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        if (t.specialToken != null) {
            this.out(t.specialToken.image);
        }
        return t.image;
    }

    public final String Name() throws ParseException {
        StringBuffer s = new StringBuffer();
        Token t = this.jj_consume_token(69);
        s.append(t.image);
        while (this.jj_2_6(2)) {
            this.jj_consume_token(80);
            t = this.jj_consume_token(69);
            s.append(".");
            s.append(t.image);
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    private boolean jj_3R_Type_1123_3_12() {
        Token xsp;
        if (this.jj_3R_NonArrayType_1135_3_18()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_Type_1124_5_19());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PlaceAccessDeclaration_599_9_13() {
        return this.jj_3R_PlaceGetterDeclaration_609_4_20();
    }

    private boolean jj_3R_PlaceAccessDeclaration_601_5_14() {
        return this.jj_3R_PlaceSetterDeclaration_646_3_21();
    }

    private boolean jj_3R_PlaceAccessDeclaration_599_4_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PlaceAccessDeclaration_599_9_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PlaceAccessDeclaration_601_5_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_PlaceSetterDeclaration_646_3_21() {
        if (this.jj_scan_token(119)) {
            return true;
        }
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_Variable_1112_3_17() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_Variable_1104_3_16() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3R_PrimitiveType_1148_3_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(16)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(13)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(47)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(36)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(38)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(28)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(22)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        if (this.jj_3R_Type_1123_3_12()) {
            return true;
        }
        if (this.jj_scan_token(69)) {
            return true;
        }
        return this.jj_scan_token(81);
    }

    private boolean jj_3R_NonArrayType_1138_5_23() {
        return this.jj_3R_Name_1181_3_25();
    }

    private boolean jj_3_4() {
        if (this.jj_3R_Variable_1092_3_11()) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_Variable_1092_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Variable_1092_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Variable_1104_3_16()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Variable_1112_3_17()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_Variable_1092_3_15() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_NonArrayType_1136_5_22() {
        return this.jj_3R_PrimitiveType_1148_3_24();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_NonArrayType_1135_3_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NonArrayType_1136_5_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_NonArrayType_1138_5_23()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_Name_1181_3_25() {
        Token xsp;
        if (this.jj_scan_token(69)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_6());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_PlaceAccessDeclaration_599_4_10();
    }

    private boolean jj_3R_PlaceGetterDeclaration_609_4_20() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_Type_1124_5_19() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        return this.jj_scan_token(77);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        return this.jj_scan_token(69);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 272709632, 272709632, 0, 0, 272709632, 272705536, 272705536, 0, 0, 0, 0, 272705536, 0, 0, 0, 0, 0, 272705536, 272705536};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{1024, 4, 0, 0, 2, 67141712, 67141712, 0, 0, 67141712, 1097808, 32848, 0, 0, 0x20000000, 0, 32848, 0, 0x104000, 256, 0x104000, 0, 32848, 32848};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 32, 32768, 0, 32, 32, 65536, 0, 32, 32, 32, 32768, 32, 58, 32768, 32, 32768, 32, 32, 32, 4096, 32, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0xC00000, 0, 0, 0xC00000, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public StubParser(InputStream stream) {
        this(stream, null);
    }

    public StubParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new StubParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StubParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new StubParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new StubParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StubParser(StubParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(StubParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[121];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 24; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 121; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        StubParser.jj_la1_init_0();
        StubParser.jj_la1_init_1();
        StubParser.jj_la1_init_2();
        StubParser.jj_la1_init_3();
        jj_ls = new LookaheadSuccess();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

