/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.serialization.dot.GraphDOT;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.VisualizationProvider;
import net.automatalib.visualization.dot.DOT;

public class GraphVizBrowserVisualizationProvider
implements VisualizationProvider {
    public static final String ID = "graphviz-browser";
    private static final int PRIORITY = 10;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean checkUsable() {
        return DOT.checkUsable();
    }

    @Override
    public <N, E> void visualize(Graph<N, E> graph, List<VisualizationHelper<N, ? super E>> additionalHelpers, boolean modal, Map<String, String> visOptions) {
        try (StringWriter sw = new StringWriter();){
            GraphDOT.write(graph, (Appendable)sw, additionalHelpers);
            File imgTmp = File.createTempFile(ID, ".png");
            DOT.runDOT(sw.getBuffer().toString(), "png", imgTmp);
            File htmlTmp = File.createTempFile(ID, ".html");
            try (Writer w = IOUtil.asBufferedUTF8Writer(htmlTmp);){
                w.write("<html><body><img src=\"");
                w.write(imgTmp.toURI().toString());
                w.write("\"></body></html>");
            }
            Desktop.getDesktop().browse(htmlTmp.toURI());
            if (modal) {
                JOptionPane.showMessageDialog(null, "Click OK to continue ...");
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Could not render graph: " + ex.getMessage());
        }
    }
}

