/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractTwoLevelIterator<L1, L2, O>
implements Iterator<O> {
    private final Iterator<? extends L1> l1Iterator;
    private L1 l1Object;
    private @Nullable Iterator<L2> l2Iterator;

    public AbstractTwoLevelIterator(Iterator<? extends L1> l1Iterator) {
        this.l1Iterator = l1Iterator;
        this.l2Iterator = null;
    }

    @Override
    public boolean hasNext() {
        if (this.l2Iterator != null && this.l2Iterator.hasNext()) {
            return true;
        }
        return this.advance();
    }

    @EnsuresNonNullIf(expression={"l2Iterator"}, result=true)
    private boolean advance() {
        while (this.l2Iterator == null || !this.l2Iterator.hasNext()) {
            if (!this.l1Iterator.hasNext()) {
                return false;
            }
            this.l1Object = this.l1Iterator.next();
            this.l2Iterator = this.l2Iterator(this.l1Object);
        }
        return true;
    }

    protected abstract Iterator<L2> l2Iterator(L1 var1);

    @Override
    public O next() {
        if (!(this.l2Iterator != null && this.l2Iterator.hasNext() || this.advance())) {
            throw new NoSuchElementException();
        }
        return this.combine(this.l1Object, this.l2Iterator.next());
    }

    protected abstract O combine(L1 var1, L2 var2);

    @Override
    public void remove() {
        if (this.l2Iterator == null) {
            throw new IllegalStateException();
        }
        this.l2Iterator.remove();
    }
}

