/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Aggregate;
import de.renew.unify.ArityBranch;
import de.renew.unify.Calculator;
import de.renew.unify.ComponentBranch;
import de.renew.unify.TupleIndex;
import de.renew.unify.TupleIndexVisitor;
import de.renew.unify.Unify;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

class EstimateVisitor
implements TupleIndexVisitor {
    public static final Logger LOGGER = Logger.getLogger(EstimateVisitor.class);
    private Set<Object> _bestSet = null;

    EstimateVisitor() {
    }

    public Set<Object> getBestSet() {
        return this._bestSet;
    }

    void possibleCollection(Set<Object> set) {
        int size = set.size();
        if (this._bestSet == null || size < this._bestSet.size()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)(" ---> found good enumeration: size " + size));
            }
            this._bestSet = set;
        }
    }

    @Override
    public void visitBranch(ComponentBranch branch) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("EstVis: visiting comp. branch " + String.valueOf(branch.getAllElements())));
        }
        this.possibleCollection(branch.getAllElements());
    }

    @Override
    public boolean visitIndex(ArityBranch branch, Object remainder) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("EstVis: visiting arity branch " + String.valueOf(branch.getHashCodeRelation())));
            LOGGER.trace((Object)("        with remainder " + String.valueOf(remainder)));
        }
        if (Unify.isBound(remainder)) {
            this.possibleCollection(branch.getHashCodeRelation().elementsAt((Object)TupleIndex.theHashCode(remainder)));
            return false;
        }
        if (remainder instanceof Aggregate) {
            return true;
        }
        if (remainder instanceof Calculator) {
            this.possibleCollection(Collections.emptySet());
            return false;
        }
        return false;
    }
}

