/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.serialisation;

import de.renew.net.INetLookup;
import de.renew.net.Net;
import de.renew.net.serialisation.INetDeserializer;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import org.apache.log4j.Logger;

public class NetDeserializer
implements INetDeserializer {
    private static final Logger LOGGER = Logger.getLogger(NetDeserializer.class);
    private static final String COPY_POSTFIX = "_COPY";
    private final INetLookup _netLookup;

    public NetDeserializer(INetLookup netLookup) {
        this._netLookup = netLookup;
    }

    @Override
    public void loadNets(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int count = objectInput.readInt();
        try {
            for (int i = 0; i < count; ++i) {
                Net net = (Net)ClassSource.readObject((ObjectInput)objectInput);
                this.readNet(net, objectInput);
                this._netLookup.makeNetKnown(net);
            }
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            throw new StreamCorruptedException("Object other than Net found when looking for nets: " + e.getMessage());
        }
        if (objectInput instanceof RenewObjectInputStream) {
            RenewObjectInputStream renewObjectInputStream = (RenewObjectInputStream)objectInput;
            renewObjectInputStream.readDelayedObjects();
        }
    }

    private void readNet(Net net, ObjectInput inputStream) {
        if (inputStream instanceof RenewObjectInputStream) {
            RenewObjectInputStream rIn = (RenewObjectInputStream)inputStream;
            if (!rIn.isCopiousBehaviour()) {
                return;
            }
            StringBuilder newName = new StringBuilder(net.getName());
            while (this._netLookup.isKnownNet(newName.toString())) {
                newName.append(COPY_POSTFIX);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Deserialized Net copy: changed name from " + net.getName() + " to " + String.valueOf(newName) + "."));
            }
            net.setName(newName.toString());
        }
    }
}

