/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.inscription.AbstractOccurrence;
import de.renew.net.inscription.arc.Arc;
import de.renew.net.inscription.arc.ArcAssignBinder;
import de.renew.net.inscription.arc.InhibitorArcBinder;
import de.renew.net.inscription.arc.InhibitorExecutable;
import de.renew.net.inscription.arc.InputArcBinder;
import de.renew.net.inscription.arc.InputArcExecutable;
import de.renew.net.inscription.arc.OutputArcExecutable;
import de.renew.net.inscription.arc.TestArcBinder;
import de.renew.net.inscription.arc.TestArcExecutable;
import de.renew.net.inscription.arc.UntestArcExecutable;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class ArcOccurrence
extends AbstractOccurrence {
    public static final Variable THE_NULL_TIME_VAR = new Variable(new Value((Object)0.0), null);
    private final Arc _arc;
    private final SimulatablePlaceInstance _placeInstance;
    private final VariableMapper _mapper;
    private Variable _tokenVar;
    private Variable _delayVar;

    protected ArcOccurrence(Arc arc, VariableMapper mapper, NetInstance netInstance) {
        super(netInstance.getInstance(arc.getTransition()));
        this._arc = arc;
        this._mapper = mapper;
        this._placeInstance = (SimulatablePlaceInstance)netInstance.getInstance(arc.getPlace());
    }

    protected InhibitorArcBinder getInhibitorArcBinder(Variable tokenVar, SimulatablePlaceInstance placeInstance) {
        return new InhibitorArcBinder(tokenVar, placeInstance);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        this._tokenVar = new Variable(this._arc.getTokenExpression().startEvaluation(this._mapper, searcher.getStateRecorder(), searcher.getCalculationChecker()), searcher.getStateRecorder());
        if (!this._arc.isUntimedArc()) {
            this._delayVar = new Variable(this._arc.getTimeExpression().startEvaluation(this._mapper, searcher.getStateRecorder(), searcher.getCalculationChecker()), searcher.getStateRecorder());
        }
        ArrayList<Binder> binders = new ArrayList<Binder>();
        if (this._arc.isTypeOf(Arc.Type.OUT)) {
            searcher.getCalculationChecker().addLateVariable(this._tokenVar, searcher.getStateRecorder());
            searcher.getCalculationChecker().addLateVariable(this._delayVar, searcher.getStateRecorder());
        } else if (this._arc.isTypeOf(Arc.Type.INHIBITOR)) {
            binders.add(this.getInhibitorArcBinder(this._tokenVar, this._placeInstance));
        } else {
            if (this._arc.getTokenExpression().isInvertible()) {
                binders.add(new ArcAssignBinder(this._tokenVar, this._placeInstance, this._arc.isTestArc()));
            }
            if (this._arc.isTestArc()) {
                binders.add(new TestArcBinder(this._tokenVar, this._placeInstance));
            } else if (this._arc.isTypeOf(Arc.Type.BOTH)) {
                binders.add(new InputArcBinder(this._tokenVar, new Variable(0, null), this._placeInstance));
                searcher.getCalculationChecker().addLateVariable(this._delayVar, searcher.getStateRecorder());
            } else {
                binders.add(new InputArcBinder(this._tokenVar, this._delayVar, this._placeInstance));
            }
        }
        return binders;
    }

    private double getDelay() {
        Object timeObj = this._delayVar.getValue();
        if (timeObj instanceof Value) {
            timeObj = ((Value)timeObj).value;
        }
        return ((Number)timeObj).doubleValue();
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        Copier copier = variableMapperCopier.getCopier();
        Variable copiedToken = (Variable)copier.copy(this._tokenVar);
        Vector<Executable> coll = new Vector<Executable>();
        switch (this._arc.getArcType()) {
            case IN: {
                coll.add(new InputArcExecutable(this._placeInstance, copiedToken.getValue(), this.getDelay(), false, this._arc.getTrace()));
                return coll;
            }
            case TEST: {
                TestArcExecutable tester = new TestArcExecutable(this._placeInstance, copiedToken.getValue(), false, this._arc.getTrace());
                return List.of(tester, new UntestArcExecutable(tester));
            }
            case OUT: {
                Variable copiedDelay = (Variable)copier.copy(this._delayVar);
                coll.add(new OutputArcExecutable(this._placeInstance, copiedToken, copiedDelay, this._arc.getTrace()));
                return coll;
            }
            case BOTH: {
                return List.of(new InputArcExecutable(this._placeInstance, copiedToken.getValue(), this.getDelay(), false, this._arc.getTrace()), new OutputArcExecutable(this._placeInstance, copiedToken, null, this._arc.getTrace()));
            }
            case FAST_BOTH: {
                coll.add(new InputArcExecutable(this._placeInstance, copiedToken.getValue(), this.getDelay(), true, this._arc.getTrace()));
                return coll;
            }
            case FAST_TEST: {
                coll.add(new TestArcExecutable(this._placeInstance, copiedToken.getValue(), true, this._arc.getTrace()));
                return coll;
            }
            case INHIBITOR: {
                coll.add(new InhibitorExecutable(this._placeInstance, copiedToken.getValue(), this._arc.getTrace()));
                return coll;
            }
            case BOTH_OT: {
                Variable copiedDelay = (Variable)copier.copy(this._delayVar);
                return Arrays.asList(new InputArcExecutable(this._placeInstance, copiedToken.getValue(), 0.0, false, this._arc.getTrace()), new OutputArcExecutable(this._placeInstance, copiedToken, copiedDelay, this._arc.getTrace()));
            }
        }
        throw new RuntimeException("Bad arc type.");
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }
}

