/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TestTokenBag
implements Serializable {
    private static final int MAX_STATIC_MULT = 15;
    private static final Integer[] MULTIPLICITIES = new Integer[16];
    private int _size = 0;
    private final Map<Object, Integer> _testCount = new HashMap<Object, Integer>();
    private final Map<Object, Double> _orgTime = new HashMap<Object, Double>();

    TestTokenBag() {
    }

    public synchronized int getUniqueSize() {
        return this._testCount.size();
    }

    public synchronized int getTestMultiplicity(Object elem) {
        return this._testCount.getOrDefault(elem, 0);
    }

    private static Integer toInteger(int result) {
        if (result <= 15) {
            return MULTIPLICITIES[result];
        }
        return result;
    }

    public synchronized Collection<Object> uniqueElements() {
        return new ArrayList<Object>(this._testCount.keySet());
    }

    public synchronized boolean includesTested(Object elem) {
        return this._testCount.containsKey(elem);
    }

    synchronized void addTested(Object elem, double time) {
        if (this._testCount.containsKey(elem)) {
            this._testCount.computeIfPresent(elem, (k, num) -> TestTokenBag.toInteger(num + 1));
        } else {
            this._testCount.put(elem, TestTokenBag.toInteger(1));
            this._orgTime.put(elem, time);
        }
        ++this._size;
    }

    synchronized double removeTested(Object elem) {
        Integer count = this._testCount.get(elem);
        if (count == null) {
            throw new RuntimeException("Negative number of tokens detected.");
        }
        double time = this._orgTime.get(elem);
        int newCount = count - 1;
        if (newCount == 0) {
            this._testCount.remove(elem);
            this._orgTime.remove(elem);
        } else {
            this._testCount.put(elem, newCount);
        }
        --this._size;
        return time;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TestTokenBag(size: ");
        buffer.append(this._size);
        buffer.append("; count'token@time:");
        for (Object token : this._testCount.keySet()) {
            buffer.append(' ');
            buffer.append(this._testCount.get(token));
            buffer.append('\'');
            buffer.append(token);
            buffer.append('@');
            buffer.append(this._orgTime.get(token));
        }
        buffer.append(')');
        return buffer.toString();
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            TestTokenBag.MULTIPLICITIES[i] = i;
        }
    }
}

