/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import java.io.Serializable;

public class NetElementID
implements Serializable {
    public static final Serializable DEFAULT_GROUP_ID = new DefaultGroupID();
    private int _figureID;
    private final Serializable _groupID;

    public NetElementID() {
        this._groupID = DEFAULT_GROUP_ID;
    }

    public NetElementID(int figureID) {
        this._figureID = figureID;
        this._groupID = DEFAULT_GROUP_ID;
    }

    public NetElementID(int figureID, Serializable groupID) {
        if (groupID == null) {
            throw new IllegalArgumentException("A null group id is invalid");
        }
        this._figureID = figureID;
        this._groupID = groupID;
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof NetElementID) {
            NetElementID otherID = (NetElementID)otherObject;
            return otherID.getFigureID() == this._figureID && this._groupID.equals(otherID.getGroupID());
        }
        return false;
    }

    public int getFigureID() {
        return this._figureID;
    }

    public Serializable getGroupID() {
        return this._groupID;
    }

    public int hashCode() {
        return this._figureID + this._groupID.hashCode();
    }

    public String toString() {
        return "[" + this._figureID + "," + String.valueOf(this._groupID) + "]";
    }

    public static class DefaultGroupID
    implements Serializable {
        private DefaultGroupID() {
        }

        public boolean equals(Object object) {
            return object instanceof DefaultGroupID;
        }

        public int hashCode() {
            return 1234;
        }

        public String toString() {
            return "_default";
        }
    }
}

