/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;
import de.renew.util.Value;

public class GuardExpression
implements Expression {
    private final Expression _argument;
    private final Function _function;

    public GuardExpression(Expression argument, Function function) {
        this._argument = argument;
        this._function = function;
    }

    @Override
    public boolean isInvertible() {
        return this._argument.isInvertible();
    }

    @Override
    public Class<?> getType() {
        return this._argument.getType();
    }

    public Expression getArgument() {
        return this._argument;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        final Variable source = new Variable(this._argument.startEvaluation(mapper, recorder, checker), recorder);
        if (checker != null) {
            checker.addEarlyVariable(source, recorder);
        }
        Notifiable sourceListener = new Notifiable(){

            @Override
            public void boundNotify(IStateRecorder irecorder) throws Impossible {
                if (Unify.isBound(source)) {
                    Object result = GuardExpression.this._function.function(source.getValue());
                    if (result instanceof Value) {
                        result = ((Value)result).value;
                    }
                    if (!Boolean.TRUE.equals(result)) {
                        throw new Impossible();
                    }
                }
            }
        };
        source.addListener(sourceListener, recorder);
        return source.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        return this._argument.registerCalculation(mapper, recorder, checker);
    }

    public String toString() {
        return "GuardExpr(" + Types.typeToString(this.getType()) + ": " + String.valueOf(this._function) + ", " + String.valueOf(this._argument) + ")";
    }
}

