/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.thread.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class DelayingInsertionFinder
implements Finder {
    private final Finder _finder;
    private Searchable _searchable;
    private final Hashtable<Searchable, Double> _times = new Hashtable();

    DelayingInsertionFinder(Finder finder) {
        this._finder = finder;
    }

    void setSearchable(Searchable searchable) {
        this._searchable = searchable;
    }

    private double getTimeFor(Searchable searchable) {
        return this._times.get(searchable);
    }

    @Override
    public void found(Searcher searcher) {
        double oldTime;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        double time = searcher.getEarliestTime();
        if (time < (oldTime = this._times.containsKey(this._searchable) ? this.getTimeFor(this._searchable) : Double.POSITIVE_INFINITY)) {
            this._times.put(this._searchable, time);
        }
        if (time <= SearchQueue.getTime()) {
            this._finder.found(searcher);
        }
    }

    @Override
    public boolean isCompleted() {
        return this._finder.isCompleted();
    }

    public void flushIntoSearchQueue() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Enumeration<Searchable> enumeration = this._times.keys();
        while (enumeration.hasMoreElements()) {
            Searchable searchable = enumeration.nextElement();
            double time = this.getTimeFor(searchable);
            SearchQueue.include(searchable, time);
        }
    }
}

