/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.SQLDialect;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class MsqlDialect
extends SQLDialect {
    @Override
    protected void setUniquePrimaryKeyValueAfterInsert(Connection connection, Entity entity, Hashtable<String, Object> values) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUniquePrimaryKeyValueBeforeInsert(Connection connection, Entity entity, Hashtable<String, Object> values) throws SQLException {
        Attribute[] primaryKey = entity.getPrimaryKey();
        if (primaryKey.length != 1) {
            throw new IllegalStateException("Auto-set primary key works only on tables with exactly one primary key attribute.\n" + entity.getTableName() + " is not such a table.");
        }
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("select _seq from ");
                query.append(entity.getTableName());
                statement = connection.createStatement();
                resultSet = statement.executeQuery(query.toString());
                if (resultSet.next()) {
                    entity.setValue(primaryKey[0].getName(), resultSet.getInt(1));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }
}

