/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.PrimaryKeyNotUniqueException;
import de.renew.database.entitylayer.SQLDialect;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class Entity
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(Entity.class);
    private static final byte NOT_MODIFIED = 0;
    private static final byte MODIFIED = 1;
    private static final byte NEW = 2;
    private static PrintStream _messageStream = null;
    private final Connection _connection;
    private final SQLDialect _dialect;
    private byte _state;
    private Hashtable<String, Object> _values;

    public Entity(Connection connection, SQLDialect dialect) {
        this._connection = connection;
        this._dialect = dialect;
        this.clear();
    }

    public void clear() {
        this._values = new Hashtable();
        this._state = (byte)2;
    }

    public Object clone() throws CloneNotSupportedException {
        Attribute[] primaryKey;
        Attribute[] attributes;
        Entity newEntity = (Entity)super.clone();
        newEntity._values = new Hashtable();
        for (Attribute attribute : attributes = this.getAttributes()) {
            Object oldValue = this.getValue(attribute.getName());
            if (oldValue == null) continue;
            newEntity._values.put(attribute.getName(), oldValue);
        }
        for (Attribute attribute : primaryKey = this.getPrimaryKey()) {
            newEntity._values.remove(attribute.getName());
        }
        newEntity._state = (byte)2;
        return newEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this._state == 2) {
                this.clear();
                return;
            }
            try (Statement statement = null;){
                String update = this._dialect.getDeleteString(this.getTableName(), this.getPrimaryKey(), this.getPrimaryKeyValue());
                if (_messageStream != null) {
                    _messageStream.println("Entity: Executing " + update);
                }
                statement = this._connection.createStatement();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (delete): " + update));
                }
                statement.executeUpdate(update);
                if (_messageStream != null) {
                    _messageStream.println("Entity: Done.");
                }
                this.clear();
            }
        }
    }

    public static void deleteEntities(Entity entityTemplate) throws SQLException {
        Entity.deleteEntities(entityTemplate, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntities(Entity entityTemplate, String condition) throws SQLException {
        Class<?> clazz = entityTemplate.getClass();
        synchronized (clazz) {
            try (Statement statement = null;){
                String update = entityTemplate.getDialect().getDeleteString(entityTemplate.getTableName(), condition);
                if (_messageStream != null) {
                    _messageStream.println("Entity: Executing " + update);
                }
                statement = entityTemplate.getConnection().createStatement();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (deleteEntities): " + update));
                }
                statement.executeUpdate(update);
                if (_messageStream != null) {
                    _messageStream.println("Entity: Done.");
                }
            }
        }
    }

    public abstract Attribute[] getAttributes();

    public Connection getConnection() {
        return this._connection;
    }

    public SQLDialect getDialect() {
        return this._dialect;
    }

    public static Vector<Entity> getEntities(Entity entityTemplate) throws SQLException {
        return Entity.getEntitiesBySelectString(entityTemplate, entityTemplate.getDialect().getSelectString(entityTemplate.getTableName(), entityTemplate.getAttributes()));
    }

    public static Vector<Entity> getEntities(Entity entityTemplate, String condition) throws SQLException {
        return Entity.getEntitiesBySelectString(entityTemplate, entityTemplate.getDialect().getSelectString(entityTemplate.getTableName(), entityTemplate.getAttributes(), condition));
    }

    public static Vector<Entity> getEntities(Entity entityTemplate, String condition, String order) throws SQLException {
        return Entity.getEntitiesBySelectString(entityTemplate, entityTemplate.getDialect().getSelectString(entityTemplate.getTableName(), entityTemplate.getAttributes(), condition, order));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<Entity> getEntitiesBySelectString(Entity entityTemplate, String query) throws SQLException {
        Class<?> clazz = entityTemplate.getClass();
        synchronized (clazz) {
            Attribute[] attributes = entityTemplate.getAttributes();
            Vector<Entity> entities = new Vector<Entity>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                if (_messageStream != null) {
                    _messageStream.println("Entity: Executing " + query);
                }
                statement = entityTemplate.getConnection().createStatement();
                resultSet = statement.executeQuery(query);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (getEntitiesBySelectString): " + query));
                }
                if (_messageStream != null) {
                    _messageStream.println("Entity: Done.");
                }
                while (resultSet.next()) {
                    Entity entity;
                    try {
                        entity = (Entity)entityTemplate.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new IllegalArgumentException("Clone of object template not possible.\nPossibly illegal attribute values?");
                    }
                    entity.clear();
                    for (int attributeNumber = 0; attributeNumber < attributes.length; ++attributeNumber) {
                        Object value = resultSet.getObject(attributeNumber + 1);
                        if (value instanceof BigDecimal) {
                            BigDecimal decimal = (BigDecimal)value;
                            entity.setValue(attributes[attributeNumber].getName(), decimal.intValue());
                            continue;
                        }
                        if (value == null) continue;
                        entity.setValue(attributes[attributeNumber].getName(), value);
                    }
                    entity._state = 0;
                    entities.addElement(entity);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            return entities;
        }
    }

    public abstract Attribute[] getPrimaryKey();

    public Object[] getPrimaryKeyValue() {
        Attribute[] primaryKey = this.getPrimaryKey();
        Object[] primaryKeyValue = new Object[primaryKey.length];
        int index = 0;
        for (Attribute attribute : primaryKey) {
            primaryKeyValue[index++] = this._values.get(attribute.getName());
        }
        return primaryKeyValue;
    }

    public byte getState() {
        return this._state;
    }

    public abstract String getTableName();

    public Object getValue(String name) {
        Object value = this._values.get(name);
        if (value instanceof byte[]) {
            byte[] byteValue = (byte[])value;
            return new String(byteValue);
        }
        return value;
    }

    public void load(Object primaryKeyValue) throws SQLException {
        this.load(new Object[]{primaryKeyValue});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Object[] primaryKeyValue) throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Attribute[] attributes = this.getAttributes();
            Attribute[] primaryKey = this.getPrimaryKey();
            if (primaryKeyValue.length != primaryKey.length) {
                throw new IllegalArgumentException("Wrong number of primary key values supplied.");
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String query = this._dialect.getSelectStringWithPrimaryKey(this.getTableName(), attributes, primaryKey, primaryKeyValue);
                if (_messageStream != null) {
                    _messageStream.println("Entity: Executing " + query);
                }
                statement = this._connection.createStatement();
                resultSet = statement.executeQuery(query);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (load): " + query));
                }
                if (_messageStream != null) {
                    _messageStream.println("Entity: Done.");
                }
                if (!resultSet.next()) {
                    throw new NoSuchEntityException("No entity with primary key " + this._dialect.getStringOfAttributesAndValues(primaryKey, primaryKeyValue) + " in table " + this.getTableName() + ".");
                }
                this.clear();
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int attributeNumber = 0; attributeNumber < columnCount; ++attributeNumber) {
                    Object value = resultSet.getObject(attributeNumber + 1);
                    if (value instanceof BigDecimal) {
                        BigDecimal decimal = (BigDecimal)value;
                        this._values.put(attributes[attributeNumber].getName(), decimal.intValue());
                        continue;
                    }
                    if (value == null) continue;
                    this._values.put(attributes[attributeNumber].getName(), value);
                }
                if (resultSet.next()) {
                    throw new PrimaryKeyNotUniqueException("Duplicate entity with primary key " + this._dialect.getStringOfAttributesAndValues(primaryKey, primaryKeyValue) + " in table " + this.getTableName() + ".");
                }
                this._state = 0;
            }
            catch (SQLException e) {
                this.clear();
                throw e;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Statement statement = null;
            Attribute[] attributes = this.getAttributes();
            Attribute[] primaryKey = this.getPrimaryKey();
            try {
                switch (this._state) {
                    case 2: {
                        int setPrimaryKeyValueCount = 0;
                        for (Attribute attribute : primaryKey) {
                            if (this._values.get(attribute.getName()) == null) continue;
                            ++setPrimaryKeyValueCount;
                        }
                        if (setPrimaryKeyValueCount > 0 && setPrimaryKeyValueCount < primaryKey.length) {
                            throw new IllegalStateException("The primary key value is only partially set.\nSet it completely to define its value or set it not at all to let the save method auto-set it.");
                        }
                        if (setPrimaryKeyValueCount < primaryKey.length) {
                            this._dialect.setUniquePrimaryKeyValueBeforeInsert(this._connection, this, this._values);
                        }
                        String update = this._dialect.getInsertString(this.getTableName(), attributes, this._values, primaryKey);
                        if (setPrimaryKeyValueCount < primaryKey.length) {
                            this._dialect.setUniquePrimaryKeyValueAfterInsert(this._connection, this, this._values);
                        }
                        if (_messageStream != null) {
                            _messageStream.println("Entity: Executing " + update);
                        }
                        statement = this._connection.createStatement();
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (save): " + update));
                        }
                        statement.executeUpdate(update);
                        if (_messageStream == null) break;
                        _messageStream.println("Entity: Done.");
                        break;
                    }
                    case 1: {
                        String update = this._dialect.getUpdateString(this.getTableName(), attributes, this._values, primaryKey);
                        if (_messageStream != null) {
                            _messageStream.println("Entity: Executing " + update);
                        }
                        statement = this._connection.createStatement();
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace((Object)(Entity.class.getSimpleName() + ": executing sql statement (save): " + update));
                        }
                        statement.executeUpdate(update);
                        if (_messageStream == null) break;
                        _messageStream.println("Entity: Done.");
                    }
                }
                this._state = 0;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public static void setMessageStream(PrintStream messageStream) {
        _messageStream = messageStream;
    }

    public void setValue(String name, Object value) {
        if (this._state != 2) {
            Attribute[] primaryKey;
            for (Attribute attribute : primaryKey = this.getPrimaryKey()) {
                if (!name.equals(attribute.getName())) continue;
                throw new IllegalArgumentException("It is illegal to change the primary key value of an existing entity.");
            }
        }
        if (value == null) {
            this._values.remove(name);
        } else {
            this._values.put(name, value);
        }
        if (this._state == 0) {
            this._state = 1;
        }
    }

    public String toString() {
        return this.getClass().getName() + "{" + this._dialect.getStringOfAttributesAndValues(this.getAttributes(), this._values) + "}";
    }

    public void touch() {
        if (this._state == 0) {
            this._state = 1;
        }
    }
}

