/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.IllegalTokenException;
import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.TransactionStrategy;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import de.renew.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DatabaseTransactionStrategy
implements TransactionStrategy {
    public static final Logger LOGGER = Logger.getLogger(DatabaseTransactionStrategy.class);
    private Connection _connection;
    private final SQLDialect _dialect;

    public DatabaseTransactionStrategy(String dbUrl, SQLDialect dialect) throws SQLException {
        this._connection = DriverManager.getConnection(dbUrl);
        this._connection.setAutoCommit(false);
        this._dialect = dialect;
    }

    public DatabaseTransactionStrategy(String dbUrl, String dbUser, String dbPassword, SQLDialect dialect) throws SQLException {
        this._connection = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        this._connection.setAutoCommit(false);
        this._dialect = dialect;
    }

    private void addTokens(TokenAction[] adds) throws SQLException, IllegalTokenException {
        for (TokenAction add : adds) {
            TokenEntity tokenEntity = new TokenEntity(this._connection, this._dialect);
            try {
                tokenEntity.load(add.getTokenID());
            }
            catch (NoSuchEntityException nsee) {
                byte[] serialisation;
                Object token = add.getToken();
                try {
                    tokenEntity.setTokenId(Integer.valueOf(add.getTokenID()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalTokenException("The token with id " + add.getTokenID() + ", class " + token.getClass().getName() + " and representation " + String.valueOf(token) + " cannot be saved, because the ID is not parsable to an int. Currently, only int IDs are supported for tokens.");
                }
                tokenEntity.setClassName(token.getClass().getName());
                try {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    new ObjectOutputStream(outStream).writeObject(token);
                    serialisation = outStream.toByteArray();
                }
                catch (Exception e) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintWriter(stream));
                    throw new IllegalTokenException("The token with id " + add.getTokenID() + ", class " + token.getClass().getName() + " and representation " + String.valueOf(token) + " couldn't be serialized, because there was an exception during serialisation: " + String.valueOf(e) + "\nOnly serializable tokens can be handled by the DatabaseTransactionStrategy.");
                }
                tokenEntity.setSerialisation(Base64Coder.encode((byte[])serialisation));
                tokenEntity.save();
            }
            TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this._connection, this._dialect);
            try {
                tokenPositionEntity.load(new Object[]{add.getTokenID(), add.getNetID(), add.getPlaceID().toString()});
                tokenPositionEntity.setQuantity(tokenPositionEntity.getQuantity() + 1);
            }
            catch (NoSuchEntityException nsee) {
                tokenPositionEntity.setTokenId(Integer.valueOf(add.getTokenID()));
                try {
                    tokenPositionEntity.setNetInstanceId(Integer.valueOf(add.getNetID()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalTokenException("The net instance ID " + add.getNetID() + " cannot be saved, because it is not parsable to an int. Currently, only int IDs are supported for net instances.");
                }
                tokenPositionEntity.setPlaceInstanceId(add.getPlaceID().toString());
                tokenPositionEntity.setQuantity(1);
            }
            tokenPositionEntity.save();
        }
    }

    private void createNets(NetAction[] creates) throws SQLException {
        for (NetAction create : creates) {
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this._connection, this._dialect);
            try {
                netInstanceEntity.load(create.getNetID());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)(DatabaseTransactionStrategy.class.getSimpleName() + ": loaded net instance entity with id " + create.getNetID()));
            }
            catch (NoSuchEntityException nsee) {
                try {
                    netInstanceEntity.setNetInstanceId(Integer.valueOf(create.getNetID()));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("The net instance ID " + create.getNetID() + " cannot be saved, because it is not parsable to an int. Currently, only int IDs are supported for net instances.");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(DatabaseTransactionStrategy.class.getSimpleName() + ": create net instance entity with name " + create.getName()));
                }
                netInstanceEntity.setName(create.getName());
                netInstanceEntity.setDrawingOpen(0);
                netInstanceEntity.save();
            }
        }
    }

    private void deleteNets(NetAction[] deletes) throws SQLException {
        for (NetAction delete : deletes) {
            try {
                NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this._connection, this._dialect);
                netInstanceEntity.load(delete.getNetID());
                TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this._connection, this._dialect);
                Vector<Entity> tokenPositionEntities = Entity.getEntities(tokenPositionEntity, "NET_INSTANCE_ID='" + delete.getNetID() + "'");
                Enumeration<Entity> tokenPositionEntitiesEnum = tokenPositionEntities.elements();
                while (tokenPositionEntitiesEnum.hasMoreElements()) {
                    tokenPositionEntity = (TokenPositionEntity)tokenPositionEntitiesEnum.nextElement();
                    String tokenId = String.valueOf(tokenPositionEntity.getTokenId());
                    tokenPositionEntity.delete();
                    if (!Entity.getEntities(tokenPositionEntity, "TOKEN_ID='" + tokenId + "'").isEmpty()) continue;
                    TokenEntity tokenEntity = new TokenEntity(this._connection, this._dialect);
                    tokenEntity.load(tokenId);
                    tokenEntity.delete();
                }
                netInstanceEntity.delete();
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws SQLException {
        if (this._connection != null) {
            this._connection.rollback();
            this._connection.close();
            this._connection = null;
        }
    }

    @Override
    public void netInstanceDrawingClosed(String netInstanceID) throws SQLException {
        try {
            LOGGER.debug((Object)("Closed " + netInstanceID));
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this._connection, this._dialect);
            netInstanceEntity.load(netInstanceID);
            netInstanceEntity.setDrawingOpen(0);
            netInstanceEntity.save();
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    @Override
    public void netInstanceDrawingOpened(String netInstanceID) throws SQLException {
        try {
            LOGGER.debug((Object)("Opened " + netInstanceID));
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this._connection, this._dialect);
            netInstanceEntity.load(netInstanceID);
            netInstanceEntity.setDrawingOpen(1);
            netInstanceEntity.save();
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    @Override
    public void perform(NetAction[] createActions, TokenAction[] addActions, TokenAction[] removeActions, NetAction[] deleteActions) throws SQLException, IllegalTokenException {
        this.createNets(createActions);
        this.addTokens(addActions);
        this.removeTokens(removeActions);
        this.deleteNets(deleteActions);
        this._connection.commit();
    }

    private void removeTokens(TokenAction[] removes) throws SQLException, IllegalTokenException {
        for (TokenAction remove : removes) {
            Object token = remove.getToken();
            if (!(token instanceof Serializable)) {
                throw new IllegalTokenException("Token " + remove.getTokenID() + " is not serializable.\nOnly serializable tokens can be handled by the DatabaseTransactionStrategy.");
            }
            try {
                TokenEntity tokenEntity = new TokenEntity(this._connection, this._dialect);
                tokenEntity.load(remove.getTokenID());
                TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this._connection, this._dialect);
                try {
                    tokenPositionEntity.load(new Object[]{remove.getTokenID(), remove.getNetID(), remove.getPlaceID().toString()});
                    if (tokenPositionEntity.getQuantity() <= 1) {
                        tokenPositionEntity.delete();
                    } else {
                        tokenPositionEntity.setQuantity(tokenPositionEntity.getQuantity() - 1);
                        tokenPositionEntity.save();
                    }
                }
                catch (NoSuchEntityException noSuchEntityException) {
                    // empty catch block
                }
                if (!Entity.getEntities(tokenPositionEntity, "TOKEN_ID='" + remove.getTokenID() + "'").isEmpty()) continue;
                tokenEntity.delete();
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
        }
    }

    @Override
    public void simulationStateChanged(boolean inited, boolean running) throws SQLException {
        StateEntity stateEntity = new StateEntity(this._connection, this._dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
        stateEntity.setInited(inited ? 1 : 0);
        stateEntity.setRunning(running ? 1 : 0);
        stateEntity.save();
        this._connection.commit();
    }
}

