/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.IllegalTokenException;
import de.renew.database.NetInstanceMap;
import de.renew.database.NetInstanceResolutionInputStream;
import de.renew.database.RestoreSource;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import de.renew.net.PlaceInstance;
import de.renew.util.Base64Coder;
import de.renew.util.ClassSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DatabaseRestoreSource
implements RestoreSource {
    private Connection _connection;
    private final SQLDialect _dialect;

    public DatabaseRestoreSource(Connection connection, SQLDialect dialect) {
        this._connection = connection;
        this._dialect = dialect;
    }

    protected void finalize() throws SQLException {
        if (this._connection != null) {
            this._connection.rollback();
            this._connection.close();
            this._connection = null;
        }
    }

    @Override
    public void fillInAllTokens(PlaceInstance placeInstance, Vector<String> ids) throws SQLException {
        TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this._connection, this._dialect);
        Vector<Entity> tokenPositionEntities = Entity.getEntities(tokenPositionEntity, "NET_INSTANCE_ID='" + placeInstance.getNetInstance().getID() + "' and PLACE_INSTANCE_ID='" + String.valueOf(placeInstance.getPlace().getID()) + "'");
        Enumeration<Entity> tokenPositionEntitiesEnum = tokenPositionEntities.elements();
        while (tokenPositionEntitiesEnum.hasMoreElements()) {
            tokenPositionEntity = (TokenPositionEntity)tokenPositionEntitiesEnum.nextElement();
            for (int i = tokenPositionEntity.getQuantity().intValue(); i > 0; --i) {
                ids.addElement(String.valueOf(tokenPositionEntity.getTokenId()));
            }
        }
    }

    @Override
    public String[] getAllNetIDs() throws SQLException {
        Vector<Entity> entities = Entity.getEntities(new NetInstanceEntity(this._connection, this._dialect));
        String[] netIds = new String[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            netIds[i] = ((NetInstanceEntity)entities.elementAt(i)).getNetInstanceId().toString();
        }
        return netIds;
    }

    public int getLastId() throws SQLException {
        int lastNetInstanceId = 0;
        NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this._connection, this._dialect);
        Vector<Entity> entities = Entity.getEntities(netInstanceEntity, null, "NET_INSTANCE_ID");
        if (!entities.isEmpty()) {
            try {
                lastNetInstanceId = ((NetInstanceEntity)entities.lastElement()).getNetInstanceId();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int lastTokenId = 0;
        TokenEntity tokenEntity = new TokenEntity(this._connection, this._dialect);
        entities = Entity.getEntities(tokenEntity, null, "TOKEN_ID");
        if (!entities.isEmpty()) {
            try {
                lastTokenId = ((TokenEntity)entities.lastElement()).getTokenId();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Math.max(lastTokenId, lastNetInstanceId);
    }

    @Override
    public String getNetName(String netID) throws SQLException {
        NetInstanceEntity entity = new NetInstanceEntity(this._connection, this._dialect);
        entity.load(netID);
        return entity.getName();
    }

    @Override
    public Hashtable<String, Object> getTokens(NetInstanceMap map) throws SQLException, IllegalTokenException {
        TokenEntity tokenEntity = new TokenEntity(this._connection, this._dialect);
        Vector<Entity> tokenEntities = Entity.getEntities(tokenEntity);
        Hashtable<String, Object> tokens = new Hashtable<String, Object>();
        Enumeration<Entity> tokenEntitiesEnum = tokenEntities.elements();
        while (tokenEntitiesEnum.hasMoreElements()) {
            tokenEntity = (TokenEntity)tokenEntitiesEnum.nextElement();
            Class tokenClass = null;
            ByteArrayInputStream inStream = null;
            ObjectInputStream netStream = null;
            try {
                tokenClass = ClassSource.classForName((String)tokenEntity.getClassName());
                inStream = new ByteArrayInputStream(Base64Coder.decode((String)tokenEntity.getSerialisation()));
                netStream = new NetInstanceResolutionInputStream(inStream, map);
                Object token = netStream.readObject();
                tokens.put(String.valueOf(tokenEntity.getTokenId()), token);
            }
            catch (InvalidClassException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nClass " + tokenClass.getName() + " is no valid class for deserialisation, because:\n" + String.valueOf(e));
            }
            catch (StreamCorruptedException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nIt has invalid serialisation data: Control information corrupt.");
            }
            catch (OptionalDataException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nIt has invalid serialisation data: Serialisation not recognized.");
            }
            catch (NotSerializableException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nIt has invalid serialisation data or the class " + tokenClass.getName() + " is not serializable.");
            }
            catch (IOException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nI/O exception during deserialisation:\n" + String.valueOf(e));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nClass " + (tokenClass != null ? tokenClass.getName() : null) + " cannot be found.");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid. It has not a valid base 64 coded serialisation.");
            }
            catch (SecurityException e) {
                throw new IllegalTokenException("The database's token with id " + tokenEntity.getTokenId() + " is invalid.\nThe default constructor of class " + (tokenClass != null ? tokenClass.getName() : null) + " is not accessible.");
            }
            finally {
                try {
                    if (netStream != null) {
                        netStream.close();
                    }
                    if (inStream == null) continue;
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tokens;
    }

    @Override
    public String[] getViewedNetIDs() throws Exception {
        Vector<Entity> entities = Entity.getEntities(new NetInstanceEntity(this._connection, this._dialect), "DRAWING_OPEN=1");
        String[] netIds = new String[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            netIds[i] = ((NetInstanceEntity)entities.elementAt(i)).getNetInstanceId().toString();
        }
        return netIds;
    }

    @Override
    public boolean wasSimulationInited() throws SQLException {
        StateEntity stateEntity = new StateEntity(this._connection, this._dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException e) {
            return false;
        }
        return stateEntity.getInited() == 1;
    }

    @Override
    public boolean wasSimulationRunning() throws SQLException {
        StateEntity stateEntity = new StateEntity(this._connection, this._dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException e) {
            return false;
        }
        return stateEntity.getRunning() == 1;
    }
}

