/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fsnet;

import de.renew.expression.CallExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.LocalVariable;
import de.renew.expression.TupleExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.fs.FSAtFunction;
import de.renew.formalism.fs.FSNetPreprocessor;
import de.renew.formalism.fs.FSUnifyExpression;
import de.renew.formalism.fs.SingleFSNetCompiler;
import de.renew.formalism.fsnet.CanInstantiateFunction;
import de.renew.formalism.fsnet.FSUnifyAtFunction;
import de.renew.formalism.fsnet.InstantiateFunction;
import de.renew.formalism.fsnet.ShadowInscriptionArea;
import de.renew.formalism.fsnet.TransitionRule;
import de.renew.formalism.fsnet.XFSNetParser;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.transition.ActionInscription;
import de.renew.net.inscription.transition.DownlinkInscription;
import de.renew.net.inscription.transition.ExpressionInscription;
import de.renew.net.inscription.transition.GuardInscription;
import de.renew.net.inscription.transition.UplinkInscription;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowTransition;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;
import java.io.StringReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SingleXFSNetCompiler
extends SingleFSNetCompiler {
    public static final Logger LOGGER = Logger.getLogger(SingleXFSNetCompiler.class);
    public static final String RESULT = "RESULT";
    public static final String IRESULT = "IRESULT";
    public static final String VAR_PREFIX = "v";
    private static int _varcnt = 0;
    private String _emptyArcVar = null;

    @Override
    protected InscriptionParser makeParser(String inscr) {
        XFSNetParser parser = new XFSNetParser(new StringReader(inscr));
        parser.setNetLoader(this._loopbackNetLoader);
        return parser;
    }

    @Override
    protected Collection<ArcInscription> parseArcInscription(String inscr) throws SyntaxException {
        if (inscr == null || inscr.equals("")) {
            inscr = "#9999";
        }
        return super.parseArcInscription(inscr);
    }

    protected void compileTransitionInscriptions(ShadowTransition shadowTransition, Vector<TransitionInscription> parsedInscriptions, Vector<ShadowInscription> errorShadows) throws SyntaxException {
        LOGGER.debug((Object)("\nCompiling Transition " + shadowTransition.getName()));
        Transition transition = this.lookup.get(shadowTransition);
        _varcnt = 0;
        this._emptyArcVar = null;
        TransitionRule transitionRule = new TransitionRule();
        transitionRule.append("[Any\n");
        Iterator inscriptions = shadowTransition.elements().iterator();
        Vector<String> inputArcVars = new Vector<String>();
        Vector<String> transVars = new Vector<String>();
        while (inscriptions.hasNext()) {
            Object elem = inscriptions.next();
            if (elem instanceof ShadowInscription) {
                ShadowInscription inscription = (ShadowInscription)elem;
                if (!inscription.getInscription().startsWith(" ")) {
                    String transVar = SingleXFSNetCompiler.newVariable();
                    transVars.addElement(transVar);
                    transitionRule.append(transVar, inscription.getInscription(), inscription);
                    continue;
                }
                Collection subinscriptions = null;
                try {
                    subinscriptions = this.makeInscriptions(inscription.getInscription().substring(1), this.getLookup().get(shadowTransition), true);
                }
                catch (SyntaxException e) {
                    throw e.addObject((Object)inscription);
                }
                Iterator i = subinscriptions.iterator();
                while (i.hasNext()) {
                    parsedInscriptions.addElement((TransitionInscription)i.next());
                    errorShadows.addElement(inscription);
                }
                continue;
            }
            if (elem instanceof ShadowArc) {
                this.compileSingleArc((ShadowArc)elem, transitionRule, inputArcVars, parsedInscriptions);
                continue;
            }
            super.compileTransitionInscriptions(shadowTransition, parsedInscriptions, errorShadows);
        }
        transitionRule.append("]");
        XFSNetParser parser = (XFSNetParser)this.makeParser(transitionRule.toString());
        parser.setLookup(this.getLookup());
        parser.setDeclarationNode(this.declaration);
        try {
            FSUnifyExpression fsExpr = parser.TransitionRule();
            Node fs = fsExpr.getTemplate().getRoot();
            String uplinkVar = null;
            String someRule = null;
            int dlVarCnt = 0;
            Enumeration tVarEnum = transVars.elements();
            while (tVarEnum.hasMoreElements()) {
                String transVar = (String)tVarEnum.nextElement();
                Name feature = new Name(VAR_PREFIX + transVar);
                Node subfs = fs.delta(feature);
                Type subfsType = subfs.getType();
                if (subfsType.getName().equals("Link")) {
                    if (!subfs.hasFeature(FSNetPreprocessor.RCV)) {
                        if (uplinkVar != null) {
                            throw new SyntaxException("Transition has more than one uplink.");
                        }
                        uplinkVar = transVar;
                        inputArcVars.addElement(transVar);
                        continue;
                    }
                    this.addDownlink(parsedInscriptions, dlVarCnt++, new Path(feature), transition);
                    continue;
                }
                if (subfsType instanceof ListType && ((ListType)subfsType).getBaseType().getName().equals("Link")) {
                    Path listPath = new Path(feature);
                    while (((ListType)fs.delta(listPath).getType()).getSubtype() == 1) {
                        Path dlPath = listPath.append(ListType.HEAD);
                        this.addDownlink(parsedInscriptions, dlVarCnt++, dlPath, transition);
                        listPath = listPath.append(ListType.TAIL);
                    }
                    continue;
                }
                someRule = VAR_PREFIX + transVar;
            }
            if (this._emptyArcVar != null && someRule != null) {
                try {
                    fsExpr = new FSUnifyExpression(fsExpr.getTemplate().equate(this._emptyArcVar, someRule), fsExpr.getPaths(), fsExpr.getExprs());
                }
                catch (UnificationFailure uff) {
                    LOGGER.error((Object)("Internal error: Unification of empty arc var and transition rule failed!\\" + String.valueOf(uff)));
                }
            }
            if (uplinkVar != null) {
                Path uplinkPath = new Path(VAR_PREFIX + uplinkVar + ":" + String.valueOf(FSNetPreprocessor.PARAM));
                LOGGER.debug((Object)(":s(v" + uplinkVar + ",TMP" + dlVarCnt + SingleXFSNetCompiler.atExpr(uplinkPath) + ",UL);"));
                parsedInscriptions.addElement((TransitionInscription)new UplinkInscription("s", (Expression)SingleXFSNetCompiler.getTriple((Expression)SingleXFSNetCompiler.getVariableExpression(uplinkVar), (Expression)SingleXFSNetCompiler.getFSAtExpression((Expression)SingleXFSNetCompiler.getVariableExpression("TMP" + dlVarCnt), uplinkPath), (Expression)SingleXFSNetCompiler.getVariableExpression("UL"))));
                LOGGER.debug((Object)("TMP" + (dlVarCnt + 1) + " = TMP" + dlVarCnt + ".unify(UL,\"" + String.valueOf(uplinkPath) + "\");"));
                parsedInscriptions.addElement((TransitionInscription)new ExpressionInscription((Expression)new EqualsExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression("TMP" + (dlVarCnt + 1)), (Expression)new CallExpression(FeatureStructure.class, (Expression)new TupleExpression(new Expression[]{SingleXFSNetCompiler.getVariableExpression("TMP" + dlVarCnt), SingleXFSNetCompiler.getVariableExpression("UL")}), (Function)new FSUnifyAtFunction(uplinkPath)))));
                ++dlVarCnt;
            }
            LOGGER.debug((Object)("RESULT = TMP" + dlVarCnt + ";"));
            parsedInscriptions.addElement((TransitionInscription)new ExpressionInscription((Expression)new EqualsExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression(RESULT), (Expression)SingleXFSNetCompiler.getVariableExpression("TMP" + dlVarCnt))));
            LOGGER.debug((Object)"action IRESULT = RESULT.instantiate();");
            parsedInscriptions.addElement((TransitionInscription)new ActionInscription((Expression)new EqualsExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression(IRESULT), (Expression)new CallExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression(RESULT), (Function)InstantiateFunction.INSTANCE)), transition));
            LOGGER.debug((Object)"guard RESULT.canInstantiate();");
            parsedInscriptions.addElement((TransitionInscription)new GuardInscription((Expression)new CallExpression(Boolean.TYPE, (Expression)SingleXFSNetCompiler.getVariableExpression(RESULT), (Function)CanInstantiateFunction.INSTANCE)));
            LOGGER.debug((Object)("TMP0=" + String.valueOf(transitionRule) + "\n+[Any"));
            Enumeration<String> varenumeration = inputArcVars.elements();
            while (varenumeration.hasMoreElements()) {
                String var = varenumeration.nextElement();
                String varpath = VAR_PREFIX + var;
                if (var.equals(uplinkVar)) {
                    varpath = varpath + ":" + String.valueOf(FSNetPreprocessor.PARAM);
                }
                LOGGER.debug((Object)(" " + varpath + ":(v" + var + ")"));
                fsExpr.getPaths().addElement(new Path(varpath));
                fsExpr.getExprs().addElement(new VariableExpression(FeatureStructure.class, new LocalVariable(var)));
            }
            LOGGER.debug((Object)"];");
            parsedInscriptions.addElement((TransitionInscription)new ExpressionInscription((Expression)new EqualsExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression("TMP0"), (Expression)fsExpr)));
        }
        catch (ParseException e) {
            throw SingleXFSNetCompiler.makeSyntaxException(e, shadowTransition, transitionRule._inscrAreas);
        }
    }

    private void addDownlink(Vector<TransitionInscription> parsedInscriptions, int dlVarCnt, Path dlpath, Transition transition) {
        String prevTmpVar = "TMP" + String.valueOf(dlVarCnt);
        String paramVar = "DL" + String.valueOf(++dlVarCnt);
        Path rcvpath = dlpath.append(FSNetPreprocessor.RCV);
        Path parampath = dlpath.append(FSNetPreprocessor.PARAM);
        LOGGER.debug((Object)(prevTmpVar + SingleXFSNetCompiler.atExpr(rcvpath) + ": s(" + prevTmpVar + SingleXFSNetCompiler.atExpr(parampath) + "," + paramVar + ",RESULT" + SingleXFSNetCompiler.atExpr(parampath) + ");"));
        parsedInscriptions.addElement((TransitionInscription)new DownlinkInscription("s", (Expression)SingleXFSNetCompiler.getTriple((Expression)SingleXFSNetCompiler.getFSAtExpression((Expression)SingleXFSNetCompiler.getVariableExpression(prevTmpVar), parampath), (Expression)SingleXFSNetCompiler.getVariableExpression(paramVar), (Expression)SingleXFSNetCompiler.getFSAtExpression((Expression)SingleXFSNetCompiler.getVariableExpression(RESULT), parampath)), (Expression)SingleXFSNetCompiler.getFSAtExpression((Expression)SingleXFSNetCompiler.getVariableExpression(prevTmpVar), rcvpath, true), false, transition));
        String tmpVar = "TMP" + dlVarCnt;
        LOGGER.debug((Object)(tmpVar + "=" + prevTmpVar + ".unify(" + paramVar + ",\"" + String.valueOf(parampath) + "\");"));
        parsedInscriptions.addElement((TransitionInscription)new ExpressionInscription((Expression)new EqualsExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression(tmpVar), (Expression)new CallExpression(FeatureStructure.class, (Expression)new TupleExpression(new Expression[]{SingleXFSNetCompiler.getVariableExpression(prevTmpVar), SingleXFSNetCompiler.getVariableExpression(paramVar)}), (Function)new FSUnifyAtFunction(parampath)))));
    }

    private static String atExpr(Path path) {
        return "@" + path.toString().replace(':', '@');
    }

    private static String newVariable() {
        return String.valueOf(_varcnt++);
    }

    public static VariableExpression getVariableExpression(String varName) {
        return new VariableExpression(FeatureStructure.class, new LocalVariable(varName));
    }

    public static CallExpression getFSAtExpression(Expression expr, Path path) {
        return SingleXFSNetCompiler.getFSAtExpression(expr, path, false);
    }

    public static CallExpression getFSAtExpression(Expression expr, Path path, boolean unpack) {
        return new CallExpression(FeatureStructure.class, expr, (Function)new FSAtFunction(path, unpack));
    }

    public static TupleExpression getTriple(Expression c1, Expression c2, Expression c3) {
        return new TupleExpression(new Expression[]{c1, c2, c3});
    }

    private void compileSingleArc(ShadowArc shadowArc, TransitionRule transitionRule, Vector<String> vars, Vector<TransitionInscription> parsedInscriptions) throws SyntaxException {
        Iterator arcinscrs = shadowArc.elements().iterator();
        if (arcinscrs.hasNext()) {
            LOGGER.debug((Object)("Type:" + shadowArc.getPlace().getName()));
            do {
                ShadowInscription inscr = (ShadowInscription)arcinscrs.next();
                this.compileArcInscription(inscr, inscr.getInscription(), shadowArc, transitionRule, vars, parsedInscriptions);
            } while (arcinscrs.hasNext());
        } else {
            this._emptyArcVar = VAR_PREFIX + this.compileArcInscription(null, "#9999", shadowArc, transitionRule, vars, parsedInscriptions);
        }
    }

    private String compileArcInscription(ShadowInscription si, String inscr, ShadowArc shadowArc, TransitionRule transitionRule, Vector<String> vars, Vector<TransitionInscription> parsedInscriptions) throws SyntaxException {
        String var = SingleXFSNetCompiler.newVariable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Found arc " + (shadowArc.isPlaceToTransition() ? "from" : "to") + " " + this.lookup.get(shadowArc.getPlace()).getName() + ", assigning variable " + var));
        }
        transitionRule.append(var, inscr, si);
        if (shadowArc.getShadowArcType() == 3 || shadowArc.getShadowArcType() == 1 && !shadowArc.isPlaceToTransition()) {
            boolean isEarly = shadowArc.getShadowArcType() == 3;
            Transition transition = this.lookup.get(shadowArc.getTransition());
            String result = isEarly ? RESULT : IRESULT;
            String vvar = VAR_PREFIX + var;
            LOGGER.debug((Object)((isEarly ? "" : "action ") + vvar + " = " + result + "@" + vvar + ";"));
            EqualsExpression outArcVarExpr = new EqualsExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression(var), (Expression)SingleXFSNetCompiler.getFSAtExpression((Expression)SingleXFSNetCompiler.getVariableExpression(result), new Path(vvar), true));
            if (isEarly) {
                parsedInscriptions.addElement((TransitionInscription)new ExpressionInscription((Expression)outArcVarExpr));
            } else {
                parsedInscriptions.addElement((TransitionInscription)new ActionInscription((Expression)outArcVarExpr, transition));
            }
        } else {
            vars.addElement(var);
        }
        this.getArcFactory(shadowArc).compileArc(this.getLookup().get(shadowArc.getPlace()), this.getLookup().get(shadowArc.getTransition()), shadowArc.getTrace(), FeatureStructure.class, (ArcInscription)new TimedExpression(new TypedExpression(FeatureStructure.class, (Expression)SingleXFSNetCompiler.getVariableExpression(var)), null));
        return var;
    }

    public static SyntaxException makeSyntaxException(ParseException pe, ShadowTransition trans, Vector<ShadowInscriptionArea> sias) {
        ShadowInscriptionArea sia = null;
        if (pe.currentToken != null) {
            Token posToken = pe.currentToken;
            if (posToken.next != null) {
                posToken = posToken.next;
            }
            int line = posToken.beginLine;
            Enumeration<ShadowInscriptionArea> siaelems = sias.elements();
            while (siaelems.hasMoreElements() && !(sia = siaelems.nextElement()).matches(line)) {
                sia = null;
            }
            if (sia != null) {
                posToken.beginLine -= sia._startLine - 1;
            }
        }
        SyntaxException se = SingleXFSNetCompiler.makeSyntaxException((ParseException)pe);
        if (sia != null) {
            se.addObject((Object)sia._inscription);
        } else {
            se.addObject((Object)trans);
        }
        return se;
    }
}

