/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Vector;
import org.apache.log4j.Logger;

class FSUnifier {
    public static final Logger LOGGER = Logger.getLogger(FSUnifier.class);
    Variable _result;
    private Vector<Variable> _variables = new Vector();
    private FeatureStructure _current;
    private int _open = 0;

    FSUnifier(FeatureStructure template, Vector<Path> paths, IStateRecorder recorder) throws Impossible {
        this._result = new Variable();
        this._current = template;
        for (int i = 0; i < paths.size(); ++i) {
            Variable variable = new Variable();
            this._variables.addElement(variable);
            this.setupListener(variable, paths.elementAt(i), recorder);
            ++this._open;
        }
        this.setupResultListener(paths, recorder);
    }

    Variable getVariable(int i) {
        return this._variables.elementAt(i);
    }

    private void setupListener(final Variable variable, final Path path, IStateRecorder recorder) throws Impossible {
        variable.addListener(new Notifiable(){

            public void boundNotify(IStateRecorder irecorder) throws Impossible {
                Object val = variable.getValue();
                final FeatureStructure oldCurrent = FSUnifier.this._current;
                if (irecorder != null) {
                    irecorder.record(new StateRestorer(){

                        public void restore() {
                            FSUnifier.this._current = oldCurrent;
                            ++FSUnifier.this._open;
                        }
                    });
                }
                --FSUnifier.this._open;
                FeatureStructure fs = val instanceof FeatureStructure ? (FeatureStructure)val : new FeatureStructure(JavaObject.getJavaType(val));
                try {
                    FSUnifier.this._current = FSUnifier.this._current.unify(fs, path);
                }
                catch (UnificationFailure uff) {
                    throw new Impossible();
                }
                if (FSUnifier.this._open == 0) {
                    Unify.unify((Object)FSUnifier.this._result, (Object)FSUnifier.this._current, (IStateRecorder)irecorder);
                }
            }
        }, recorder);
    }

    private void setupResultListener(final Vector<Path> paths, IStateRecorder recorder) throws Impossible {
        this._result.addListener(new Notifiable(){

            public void boundNotify(IStateRecorder irecorder) throws Impossible {
                Object val = FSUnifier.this._result.getValue();
                if (!(val instanceof FeatureStructure)) {
                    throw new Impossible();
                }
                FeatureStructure resultfs = (FeatureStructure)val;
                if (!FSUnifier.this._current.subsumes(resultfs)) {
                    LOGGER.debug((Object)("Current: " + String.valueOf(FSUnifier.this._current) + "resultfs:" + String.valueOf(resultfs)));
                    throw new Impossible();
                }
                for (int i = 0; i < paths.size(); ++i) {
                    Variable variable = FSUnifier.this._variables.elementAt(i);
                    if (Unify.isBound((Object)variable)) continue;
                    Path path = (Path)paths.elementAt(i);
                    Unify.unify((Object)variable, (Object)resultfs.unpackingAt(path), (IStateRecorder)irecorder);
                }
            }
        }, recorder);
    }
}

