/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.engine.events.SimulationEvent;
import de.renew.logging.gui.StepTraceChangeListener;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class StepTrace {
    private Vector<SimulationEvent> _events = new Vector();
    private Set<StepTraceChangeListener> _listeners = Collections.synchronizedSet(new HashSet());
    private StepIdentifier _step;

    public StepTrace(StepIdentifier step) {
        this._step = step;
    }

    public void log(SimulationEvent event) {
        if (!this._events.contains(event)) {
            this._events.add(event);
            this.fireStepTraceChanged();
        }
    }

    public SimulationEvent[] getEvents() {
        return this._events.toArray(new SimulationEvent[0]);
    }

    public StepIdentifier getStepIdentifier() {
        return this._step;
    }

    public String toString() {
        return "Simulator Step " + String.valueOf(this._step);
    }

    public void addStepTraceChangeListener(StepTraceChangeListener listener) {
        this._listeners.add(listener);
    }

    public boolean removeStepTraceChangeListener(StepTraceChangeListener listener) {
        return this._listeners.remove(listener);
    }

    public void fireStepTraceChanged() {
        StepTraceChangeListener[] l = this._listeners.toArray(new StepTraceChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceChanged(this);
        }
    }
}

