/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import org.eclipse.jgit.lib.Config;

public class DfsReaderOptions {
    public static final int KiB = 1024;
    public static final int MiB = 0x100000;
    private int deltaBaseCacheLimit;
    private int streamFileThreshold;

    public DfsReaderOptions() {
        this.setDeltaBaseCacheLimit(0xA00000);
        this.setStreamFileThreshold(0x3200000);
    }

    public int getDeltaBaseCacheLimit() {
        return this.deltaBaseCacheLimit;
    }

    public DfsReaderOptions setDeltaBaseCacheLimit(int maxBytes) {
        this.deltaBaseCacheLimit = Math.max(0, maxBytes);
        return this;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public DfsReaderOptions setStreamFileThreshold(int newLimit) {
        this.streamFileThreshold = Math.max(0, newLimit);
        return this;
    }

    public DfsReaderOptions fromConfig(Config rc) {
        this.setDeltaBaseCacheLimit(rc.getInt("core", "dfs", "deltaBaseCacheLimit", this.getDeltaBaseCacheLimit()));
        long maxMem = Runtime.getRuntime().maxMemory();
        long sft = rc.getLong("core", "dfs", "streamFileThreshold", this.getStreamFileThreshold());
        sft = Math.min(sft, maxMem / 4L);
        sft = Math.min(sft, Integer.MAX_VALUE);
        this.setStreamFileThreshold((int)sft);
        return this;
    }
}

