/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ioontology;

import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.MultiExtensionFileFilter;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class MultiExtensionFileFilterImpl
extends FileFilter
implements MultiExtensionFileFilter {
    private final HashSet<ExtensionFileFilter> _filterList = new HashSet();
    private ExtensionFileFilter _preferredFileFilter;
    private String _description;

    public MultiExtensionFileFilterImpl(String description) {
        this._description = description;
    }

    public MultiExtensionFileFilterImpl(String description, Collection<ExtensionFileFilter> filters) {
        this._description = description;
        this.addAll(filters);
    }

    @Override
    public final void setDescription(String description) {
        this._description = description;
    }

    @Override
    public final boolean add(ExtensionFileFilter ff) {
        if (ff != null && this._filterList.contains(ff)) {
            return false;
        }
        if (this._filterList.isEmpty()) {
            this._preferredFileFilter = ff;
        }
        return this._filterList.add(ff);
    }

    @Override
    public final boolean addAll(Collection<? extends ExtensionFileFilter> filters) {
        boolean result = false;
        for (ExtensionFileFilter extensionFileFilter : filters) {
            result = this.add(extensionFileFilter) || result;
        }
        return result;
    }

    @Override
    public final void remove(ExtensionFileFilter ff) {
        this._filterList.remove(ff);
    }

    @Override
    public final Set<ExtensionFileFilter> getFileFilters() {
        return this._filterList;
    }

    @Override
    public boolean accept(File f) {
        if (f == null || f.isHidden() || f.getName().startsWith(".")) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        for (ExtensionFileFilter filter : this._filterList) {
            if (!filter.accept(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final ExtensionFileFilter getPreferredFileFilter() {
        return this._preferredFileFilter;
    }

    @Override
    public final void setPreferredFileFilter(ExtensionFileFilter filter) {
        this._preferredFileFilter = filter;
    }

    @Override
    public final String getDescription() {
        return this._description;
    }

    public final boolean equals(Object o) {
        if (o instanceof MultiExtensionFileFilterImpl) {
            MultiExtensionFileFilterImpl other = (MultiExtensionFileFilterImpl)o;
            return this.getDescription().equals(other.getDescription()) && this.getFileFilters().equals(other.getFileFilters());
        }
        return false;
    }

    public final int hashCode() {
        return MultiExtensionFileFilterImpl.class.hashCode() ^ this.getDescription().hashCode() ^ this.getFileFilters().hashCode();
    }
}

