/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.ui.impl.services;

import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.SelectCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.SpreadCommand;
import de.renew.draw.storables.ontology.FigureFilter;
import de.renew.draw.ui.api.services.CommandService;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.Alignment;
import de.renew.draw.ui.ontology.Anchor;
import de.renew.draw.ui.ontology.SelectionMode;
import de.renew.draw.ui.ontology.SpreadMode;
import de.renew.plugin.IPlugin;

public final class CommandServiceImpl
implements CommandService {
    @Override
    public AbstractCommand createCommand(String name, final Runnable runnable) {
        return new AbstractCommand(name){

            @Override
            public void execute() {
                runnable.run();
            }
        };
    }

    @Override
    public AbstractCommand createVersionInfoCommand(IPlugin plugin) {
        return new VersionInfoCommand(plugin);
    }

    @Override
    public AbstractCommand createGroupCommand(String name) {
        return new GroupCommand(name);
    }

    @Override
    public AbstractCommand createUngroupCommand(String name) {
        return new UngroupCommand(name);
    }

    @Override
    public AbstractCommand createSelectCommand(String name, Class<?> figureClass, SelectionMode mode) {
        return new SelectCommand(name, figureClass, mode.ordinal());
    }

    @Override
    public AbstractCommand createSelectCommand(String name, Class<?> figureClass, Class<?> parentClass, SelectionMode mode) {
        return new SelectCommand(name, figureClass, parentClass, mode.ordinal());
    }

    @Override
    public AbstractCommand createSelectCommand(String name, FigureFilter filter, SelectionMode mode) {
        int code = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case SelectionMode.SELECT -> 0;
            case SelectionMode.ADD -> 1;
            case SelectionMode.REMOVE -> 2;
            case SelectionMode.RESTRICT -> 3;
        };
        return new SelectCommand(name, filter, code);
    }

    @Override
    public AbstractCommand createAlignCommand(String name, Alignment alignment) {
        int code = switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case Alignment.LEFTS -> 0;
            case Alignment.CENTERS -> 1;
            case Alignment.RIGHTS -> 2;
            case Alignment.TOPS -> 3;
            case Alignment.MIDDLES -> 4;
            case Alignment.BOTTOMS -> 5;
        };
        return new AlignCommand(name, code);
    }

    @Override
    public AbstractCommand createAlignCommand(String name, Alignment alignment, Anchor anchor) {
        int anchorCode = switch (anchor) {
            default -> throw new IncompatibleClassChangeError();
            case Anchor.ANCHOR_LAST -> 0;
            case Anchor.ANCHOR_FIRST -> 1;
            case Anchor.ANCHOR_BIGGEST -> 2;
            case Anchor.ANCHOR_SMALLEST -> 3;
            case Anchor.ANCHOR_SELECTION -> 4;
        };
        int alignmentCode = switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case Alignment.LEFTS -> 0;
            case Alignment.CENTERS -> 1;
            case Alignment.RIGHTS -> 2;
            case Alignment.TOPS -> 3;
            case Alignment.MIDDLES -> 4;
            case Alignment.BOTTOMS -> 5;
        };
        return new AlignCommand(name, alignmentCode, anchorCode);
    }

    @Override
    public AbstractCommand createSpreadCommand(String name, SpreadMode mode) {
        int code = switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case SpreadMode.LEFTS -> 0;
            case SpreadMode.CENTERS -> 1;
            case SpreadMode.RIGHTS -> 2;
            case SpreadMode.TOPS -> 3;
            case SpreadMode.MIDDLES -> 4;
            case SpreadMode.BOTTOMS -> 5;
            case SpreadMode.HORIZONTAL_DISTANCE -> 6;
            case SpreadMode.VERTICAL_DISTANCE -> 7;
            case SpreadMode.DIAGONAL_CENTERS -> 8;
        };
        return new SpreadCommand(name, code);
    }

    @Override
    public AbstractCommand createChangeAttributeCommand(String commandName, String attributeName, Object attributeValue) {
        return new ChangeAttributeCommand(commandName, attributeName, attributeValue);
    }
}

