/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class PaletteLayout
implements LayoutManager {
    private final int _gap;
    private final Point _border;
    private boolean _verticalLayout;

    public PaletteLayout(int gap) {
        this(gap, new Point(0, 0), true);
    }

    public PaletteLayout(int gap, Point border) {
        this(gap, border, true);
    }

    public PaletteLayout(int gap, Point border, boolean vertical) {
        this._gap = gap;
        this._border = border;
        this._verticalLayout = vertical;
    }

    public void setVertical(boolean vertical) {
        this._verticalLayout = vertical;
    }

    public boolean isVertical() {
        return this._verticalLayout;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.minimumLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                if (this._verticalLayout) {
                    dim.width = Math.max(dim.width, d.width);
                    if (i > 0) {
                        dim.height += this._gap;
                    }
                    dim.height += d.height;
                    continue;
                }
                dim.height = Math.max(dim.height, d.height);
                if (i > 0) {
                    dim.width += this._gap;
                }
                dim.width += d.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.width += 2 * this._border.x;
            dim.height += insets.top + insets.bottom;
            dim.height += 2 * this._border.y;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int nmembers = target.getComponentCount();
            int x = insets.left + this._border.x;
            int y = insets.top + this._border.y;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                m.setBounds(x, y, d.width, d.height);
                if (this._verticalLayout) {
                    y += d.height;
                    y += this._gap;
                    continue;
                }
                x += d.width;
                x += this._gap;
            }
        }
    }
}

