/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import de.renew.util.Scheduler;
import java.awt.EventQueue;

public class AWTSynchronizedUpdate
implements Runnable {
    private boolean _inUpdate = false;
    private boolean _anotherTurn = false;
    private final Runnable _updateTask;
    private final long _updateDelay;
    private final DelayingTask _delayingTask;

    public AWTSynchronizedUpdate(Runnable updateTask) {
        this(0L, updateTask);
    }

    public AWTSynchronizedUpdate(long updateDelay, Runnable updateTask) {
        this._updateDelay = updateDelay;
        this._updateTask = updateTask;
        this._delayingTask = new DelayingTask(this);
    }

    public synchronized void scheduleUpdate() {
        this._anotherTurn = true;
        if (!this._inUpdate) {
            if (this._updateDelay == 0L) {
                EventQueue.invokeLater(this);
            } else {
                Scheduler.instance().executeIn((Runnable)this._delayingTask, this._updateDelay);
            }
            this._inUpdate = true;
        }
    }

    private synchronized boolean testAndResetUpdateRequest() {
        this._inUpdate = this._anotherTurn;
        this._anotherTurn = false;
        if (this._updateDelay == 0L) {
            return this._inUpdate;
        }
        if (this._inUpdate) {
            Scheduler.instance().executeIn((Runnable)this._delayingTask, this._updateDelay);
        }
        return false;
    }

    @Override
    public void run() {
        this.testAndResetUpdateRequest();
        do {
            this._updateTask.run();
        } while (this.testAndResetUpdateRequest());
    }

    private static class DelayingTask
    implements Runnable {
        private final AWTSynchronizedUpdate _instance;

        public DelayingTask(AWTSynchronizedUpdate instance) {
            this._instance = instance;
        }

        @Override
        public void run() {
            EventQueue.invokeLater(this._instance);
        }
    }
}

